/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.tz;

import java.sql.SQLException;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.tz.TimeZoneMapping;
import org.firebirdsql.logging.LoggerFactory;

public class TimeZoneDatatypeCoder {
    private static final int SIZE_OF_TIMESTAMPTZ = 12;
    private static final int SIZE_OF_TIMETZ = 8;
    private static final int MAX_CACHED = 4;
    private static final Map<DatatypeCoder, TimeZoneDatatypeCoder> instanceCache = new ConcurrentHashMap<DatatypeCoder, TimeZoneDatatypeCoder>(4);
    private static final LocalDate TIME_TZ_BASE_DATE = LocalDate.of(2020, 1, 1);
    private static final TemporalAdjuster TIME_TZ_BASE_DATE_ADJUSTER = TemporalAdjusters.ofDateAdjuster(currentDate -> TIME_TZ_BASE_DATE);
    private final DatatypeCoder datatypeCoder;
    private final Clock utcClock;
    private final TimeZoneMapping timeZoneMapping = TimeZoneMapping.getInstance();
    private TimeZoneCodec standardTimeWithTimeZoneCodec;
    private TimeZoneCodec standardTimestampWithTimeZoneCodec;
    private TimeZoneCodec extendedTimeWithTimeZoneCodec;
    private TimeZoneCodec extendedTimestampWithTimeZoneCodec;

    public TimeZoneDatatypeCoder(DatatypeCoder datatypeCoder) {
        this(datatypeCoder, Clock.systemUTC());
    }

    TimeZoneDatatypeCoder(DatatypeCoder datatypeCoder, Clock utcClock) {
        this.datatypeCoder = datatypeCoder;
        this.utcClock = utcClock;
    }

    public TimeZoneCodec getTimeZoneCodecFor(FieldDescriptor fieldDescriptor) throws SQLException {
        return this.getTimeZoneCodecFor(fieldDescriptor.getType());
    }

    public TimeZoneCodec getTimeZoneCodecFor(int fieldType) throws SQLException {
        switch (fieldType & 0xFFFFFFFE) {
            case 32754: {
                if (this.standardTimestampWithTimeZoneCodec != null) {
                    return this.standardTimestampWithTimeZoneCodec;
                }
                this.standardTimestampWithTimeZoneCodec = new TimestampWithTimeZoneCodec(fieldType);
                return this.standardTimestampWithTimeZoneCodec;
            }
            case 32756: {
                if (this.standardTimeWithTimeZoneCodec != null) {
                    return this.standardTimeWithTimeZoneCodec;
                }
                this.standardTimeWithTimeZoneCodec = new TimeWithTimeZoneCodec(fieldType);
                return this.standardTimeWithTimeZoneCodec;
            }
            case 32748: {
                if (this.extendedTimestampWithTimeZoneCodec != null) {
                    return this.extendedTimestampWithTimeZoneCodec;
                }
                this.extendedTimestampWithTimeZoneCodec = new TimestampWithTimeZoneCodec(fieldType);
                return this.extendedTimestampWithTimeZoneCodec;
            }
            case 32750: {
                if (this.extendedTimeWithTimeZoneCodec != null) {
                    return this.extendedTimeWithTimeZoneCodec;
                }
                this.extendedTimeWithTimeZoneCodec = new TimeWithTimeZoneCodec(fieldType);
                return this.extendedTimeWithTimeZoneCodec;
            }
        }
        throw FbExceptionBuilder.forException(337248277).messageParameter(fieldType).toSQLException();
    }

    private ZoneId decodeTimeZoneId(byte[] tzValueBytes, int zoneIdOffset) {
        int timeZoneId = this.datatypeCoder.decodeShort(tzValueBytes, zoneIdOffset) & 0xFFFF;
        return this.timeZoneMapping.timeZoneById(timeZoneId);
    }

    private <T extends Temporal> T decodeTimestampTz(byte[] timestampTzBytes, BiFunction<Instant, ZoneId, T> conversionFunction) {
        Instant instant = this.decodeTimestampTzAsInstant(timestampTzBytes);
        ZoneId zoneId = this.decodeTimeZoneId(timestampTzBytes, 8);
        return (T)((Temporal)conversionFunction.apply(instant, zoneId));
    }

    private Instant decodeTimestampTzAsInstant(byte[] timestampTzBytes) {
        int encodedDate = this.datatypeCoder.decodeInt(timestampTzBytes);
        int encodedTime = this.datatypeCoder.decodeInt(timestampTzBytes, 4);
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct(encodedDate, true, encodedTime, true);
        LocalDateTime utcDateTime = LocalDateTime.of(raw.year, raw.month, raw.day, raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
        return utcDateTime.toInstant(ZoneOffset.UTC);
    }

    private byte[] encodeOffsetDateTimeToTimestampTz(OffsetDateTime offsetDateTime, int bufferSize) {
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(offsetDateTime.getOffset());
        LocalDateTime utcDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC).toLocalDateTime();
        return this.encodeTimestampTz(utcDateTime, firebirdZoneId, bufferSize);
    }

    private byte[] encodeZonedDateTimeToTimestampTz(ZonedDateTime zonedDateTime, int bufferSize) {
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(zonedDateTime.getZone());
        LocalDateTime utcDateTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        return this.encodeTimestampTz(utcDateTime, firebirdZoneId, bufferSize);
    }

    private byte[] encodeTimestampTz(LocalDateTime utcDateTime, int firebirdZoneId, int bufferSize) {
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct();
        raw.year = utcDateTime.getYear();
        raw.month = utcDateTime.getMonthValue();
        raw.day = utcDateTime.getDayOfMonth();
        raw.hour = utcDateTime.getHour();
        raw.minute = utcDateTime.getMinute();
        raw.second = utcDateTime.getSecond();
        raw.setFractionsFromNanos(utcDateTime.getNano());
        byte[] timestampTzBytes = new byte[bufferSize];
        this.datatypeCoder.encodeInt(raw.getEncodedDate(), timestampTzBytes, 0);
        this.datatypeCoder.encodeInt(raw.getEncodedTime(), timestampTzBytes, 4);
        this.datatypeCoder.encodeShort((short)firebirdZoneId, timestampTzBytes, 8);
        return timestampTzBytes;
    }

    private LocalTime decodeTimeTzToUtcLocalTime(byte[] timeTzBytes) {
        int encodedTime = this.datatypeCoder.decodeInt(timeTzBytes);
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct(0, false, encodedTime, true);
        return LocalTime.of(raw.hour, raw.minute, raw.second, raw.getFractionsAsNanos());
    }

    private OffsetTime decodeTimeTzToOffsetTime(byte[] timeTzBytes) {
        LocalTime utcTime = this.decodeTimeTzToUtcLocalTime(timeTzBytes);
        ZoneId zoneId = this.decodeTimeZoneId(timeTzBytes, 4);
        if (zoneId instanceof ZoneOffset) {
            return OffsetTime.of(utcTime, ZoneOffset.UTC).withOffsetSameInstant((ZoneOffset)zoneId);
        }
        return ZonedDateTime.of(TIME_TZ_BASE_DATE, utcTime, ZoneOffset.UTC).withZoneSameInstant(zoneId).toOffsetDateTime().toOffsetTime();
    }

    private OffsetDateTime decodeTimeTzToOffsetDateTime(byte[] timeTzBytes) {
        LocalTime utcTime = this.decodeTimeTzToUtcLocalTime(timeTzBytes);
        ZoneId zoneId = this.decodeTimeZoneId(timeTzBytes, 4);
        if (zoneId instanceof ZoneOffset) {
            LocalDate utcToday = OffsetDateTime.ofInstant(this.utcClock.instant(), ZoneOffset.UTC).toLocalDate();
            return OffsetDateTime.of(utcToday, utcTime, ZoneOffset.UTC).withOffsetSameInstant((ZoneOffset)zoneId);
        }
        return this.decodeTimeTzToZonedDateTime(utcTime, zoneId).toOffsetDateTime();
    }

    private ZonedDateTime decodeTimeTzToZonedDateTime(byte[] timeTzBytes) {
        LocalTime utcTime = this.decodeTimeTzToUtcLocalTime(timeTzBytes);
        ZoneId zoneId = this.decodeTimeZoneId(timeTzBytes, 4);
        return this.decodeTimeTzToZonedDateTime(utcTime, zoneId);
    }

    private ZonedDateTime decodeTimeTzToZonedDateTime(LocalTime utcTime, ZoneId zoneId) {
        ZonedDateTime timeAtBaseDate = ZonedDateTime.of(TIME_TZ_BASE_DATE, utcTime, ZoneOffset.UTC).withZoneSameInstant(zoneId);
        LocalDate currentDateInZone = ZonedDateTime.ofInstant(this.utcClock.instant(), zoneId).toLocalDate();
        return timeAtBaseDate.with(TemporalAdjusters.ofDateAdjuster(date -> currentDateInZone));
    }

    private byte[] encodeOffsetTimeToTimeTz(OffsetTime offsetTime, int bufferSize) {
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(offsetTime.getOffset());
        LocalTime utcTime = offsetTime.withOffsetSameInstant(ZoneOffset.UTC).toLocalTime();
        return this.encodeTimeTz(utcTime, firebirdZoneId, bufferSize);
    }

    private byte[] encodeZonedDateTimeToTimeTz(ZonedDateTime zonedDateTime, int bufferSize) {
        ZoneId zone = zonedDateTime.getZone();
        int firebirdZoneId = this.timeZoneMapping.toTimeZoneId(zone);
        if (!this.timeZoneMapping.isOffsetTimeZone(firebirdZoneId)) {
            zonedDateTime = zonedDateTime.with(TIME_TZ_BASE_DATE_ADJUSTER);
        }
        LocalTime utcTime = zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalTime();
        return this.encodeTimeTz(utcTime, firebirdZoneId, bufferSize);
    }

    private byte[] encodeTimeTz(LocalTime utcTime, int firebirdZoneId, int bufferSize) {
        DatatypeCoder.RawDateTimeStruct raw = new DatatypeCoder.RawDateTimeStruct();
        raw.hour = utcTime.getHour();
        raw.minute = utcTime.getMinute();
        raw.second = utcTime.getSecond();
        raw.setFractionsFromNanos(utcTime.getNano());
        byte[] timeTzBytes = new byte[bufferSize];
        this.datatypeCoder.encodeInt(raw.getEncodedTime(), timeTzBytes, 0);
        this.datatypeCoder.encodeShort((short)firebirdZoneId, timeTzBytes, 4);
        return timeTzBytes;
    }

    public static TimeZoneDatatypeCoder getInstanceFor(DatatypeCoder datatypeCoder) {
        DatatypeCoder rootCoder = datatypeCoder.unwrap();
        TimeZoneDatatypeCoder cachedValue = instanceCache.get(rootCoder);
        if (cachedValue != null) {
            return cachedValue;
        }
        return TimeZoneDatatypeCoder.createdCachedInstance(rootCoder);
    }

    private static TimeZoneDatatypeCoder createdCachedInstance(DatatypeCoder rootCoder) {
        if (instanceCache.size() > 4) {
            LoggerFactory.getLogger(TimeZoneDatatypeCoder.class).info("Clearing TimeZoneDatatypeCoder.instanceCache");
            instanceCache.clear();
        }
        TimeZoneDatatypeCoder value = new TimeZoneDatatypeCoder(rootCoder);
        instanceCache.putIfAbsent(rootCoder, value);
        return value;
    }

    private class TimestampWithTimeZoneCodec
    implements TimeZoneCodec {
        private final int encodedSize;

        private TimestampWithTimeZoneCodec(int type) {
            assert ((type &= 0xFFFFFFFE) == 32754 || type == 32748) : "Not a TIMESTAMP WITH TIME ZONE type, was " + type;
            this.encodedSize = type == 32754 ? 12 : 12 + (TimeZoneDatatypeCoder.this.datatypeCoder.sizeOfShort() == 2 ? 0 : 4);
        }

        @Override
        public byte[] encodeOffsetDateTime(OffsetDateTime offsetDateTime) {
            return TimeZoneDatatypeCoder.this.encodeOffsetDateTimeToTimestampTz(offsetDateTime, this.encodedSize);
        }

        @Override
        public OffsetDateTime decodeOffsetDateTime(byte[] fieldData) {
            assert (fieldData.length == this.encodedSize) : "timestampTzBytes not length " + this.encodedSize;
            return (OffsetDateTime)TimeZoneDatatypeCoder.this.decodeTimestampTz(fieldData, OffsetDateTime::ofInstant);
        }

        @Override
        public byte[] encodeOffsetTime(OffsetTime offsetTime) {
            ZoneOffset offset = offsetTime.getOffset();
            OffsetDateTime today = OffsetDateTime.ofInstant(TimeZoneDatatypeCoder.this.utcClock.instant(), offsetTime.getOffset());
            OffsetDateTime timeToday = OffsetDateTime.of(today.toLocalDate(), offsetTime.toLocalTime(), offset);
            return this.encodeOffsetDateTime(timeToday);
        }

        @Override
        public OffsetTime decodeOffsetTime(byte[] fieldData) {
            return this.decodeOffsetDateTime(fieldData).toOffsetTime();
        }

        @Override
        public byte[] encodeZonedDateTime(ZonedDateTime zonedDateTime) {
            return TimeZoneDatatypeCoder.this.encodeZonedDateTimeToTimestampTz(zonedDateTime, this.encodedSize);
        }

        @Override
        public ZonedDateTime decodeZonedDateTime(byte[] fieldData) {
            assert (fieldData.length == this.encodedSize) : "timestampTzBytes not length " + this.encodedSize;
            return (ZonedDateTime)TimeZoneDatatypeCoder.this.decodeTimestampTz(fieldData, ZonedDateTime::ofInstant);
        }
    }

    private class TimeWithTimeZoneCodec
    implements TimeZoneCodec {
        private final int encodedSize;

        private TimeWithTimeZoneCodec(int type) {
            assert ((type &= 0xFFFFFFFE) == 32756 || type == 32750) : "Not a TIME WITH TIME ZONE type, was " + type;
            this.encodedSize = type == 32756 ? 8 : 8 + (TimeZoneDatatypeCoder.this.datatypeCoder.sizeOfShort() == 2 ? 0 : 4);
        }

        @Override
        public byte[] encodeOffsetDateTime(OffsetDateTime offsetDateTime) {
            return this.encodeOffsetTime(offsetDateTime.toOffsetTime());
        }

        @Override
        public OffsetDateTime decodeOffsetDateTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeTimeTzToOffsetDateTime(fieldData);
        }

        @Override
        public byte[] encodeOffsetTime(OffsetTime offsetTime) {
            return TimeZoneDatatypeCoder.this.encodeOffsetTimeToTimeTz(offsetTime, this.encodedSize);
        }

        @Override
        public OffsetTime decodeOffsetTime(byte[] fieldData) {
            assert (fieldData.length == this.encodedSize) : "timestampTzBytes not length " + this.encodedSize;
            return TimeZoneDatatypeCoder.this.decodeTimeTzToOffsetTime(fieldData);
        }

        @Override
        public byte[] encodeZonedDateTime(ZonedDateTime zonedDateTime) {
            return TimeZoneDatatypeCoder.this.encodeZonedDateTimeToTimeTz(zonedDateTime, this.encodedSize);
        }

        @Override
        public ZonedDateTime decodeZonedDateTime(byte[] fieldData) {
            return TimeZoneDatatypeCoder.this.decodeTimeTzToZonedDateTime(fieldData);
        }
    }

    public static interface TimeZoneCodec {
        public byte[] encodeOffsetDateTime(OffsetDateTime var1);

        public OffsetDateTime decodeOffsetDateTime(byte[] var1);

        public byte[] encodeOffsetTime(OffsetTime var1);

        public OffsetTime decodeOffsetTime(byte[] var1);

        public byte[] encodeZonedDateTime(ZonedDateTime var1);

        public ZonedDateTime decodeZonedDateTime(byte[] var1);
    }
}

