# frozen_string_literal: true
#  Include the English library file in a Ruby script, and you can
#  reference the global variables such as <code>$_</code> using less
#  cryptic names, listed below.
#
#  Without 'English':
#
#      $\ = ' -- '
#      "waterbuffalo" =~ /buff/
#      print $', $$, "\n"
#
#  With English:
#
#      require "English"
#
#      $OUTPUT_FIELD_SEPARATOR = ' -- '
#      "waterbuffalo" =~ /buff/
#      print $POSTMATCH, $PID, "\n"
#
#  Below is a full list of descriptive aliases and their associated global
#  variable:
#
#  $ERROR_INFO::              $!
#  $ERROR_POSITION::          $@
#  $FS::                      $;
#  $FIELD_SEPARATOR::         $;
#  $OFS::                     $,
#  $OUTPUT_FIELD_SEPARATOR::  $,
#  $RS::                      $/
#  $INPUT_RECORD_SEPARATOR::  $/
#  $ORS::                     $\
#  $OUTPUT_RECORD_SEPARATOR:: $\
#  $INPUT_LINE_NUMBER::       $.
#  $NR::                      $.
#  $LAST_READ_LINE::          $_
#  $DEFAULT_OUTPUT::          $>
#  $DEFAULT_INPUT::           $<
#  $PID::                     $$
#  $PROCESS_ID::              $$
#  $CHILD_STATUS::            $?
#  $LAST_MATCH_INFO::         $~
#  $ARGV::                    $*
#  $MATCH::                   $&
#  $PREMATCH::                $`
#  $POSTMATCH::               $'
#  $LAST_PAREN_MATCH::        $+
#
module English end if false

# The exception object passed to +raise+.
alias $ERROR_INFO              $!

# The stack backtrace generated by the last
# exception. See Kernel#caller for details. Thread local.
alias $ERROR_POSITION          $@

# The default separator pattern used by String#split.  May be set from
# the command line using the <code>-F</code> flag.
alias $FS                      $;
alias $FIELD_SEPARATOR         $;

# The separator string output between the parameters to methods such
# as Kernel#print and Array#join. Defaults to +nil+, which adds no
# text.

# The separator string output between the parameters to methods such
# as Kernel#print and Array#join. Defaults to +nil+, which adds no
# text.
alias $OFS                     $,
alias $OUTPUT_FIELD_SEPARATOR  $,

# The input record separator (newline by default). This is the value
# that routines such as Kernel#gets use to determine record
# boundaries. If set to +nil+, +gets+ will read the entire file.
alias $RS                      $/
alias $INPUT_RECORD_SEPARATOR  $/

# The string appended to the output of every call to methods such as
# Kernel#print and IO#write. The default value is +nil+.
alias $ORS                     $\
alias $OUTPUT_RECORD_SEPARATOR $\

# The number of the last line read from the current input file.
alias $NR                      $.
alias $INPUT_LINE_NUMBER       $.

# The last line read by Kernel#gets or
# Kernel#readline. Many string-related functions in the
# Kernel module operate on <code>$_</code> by default. The variable is
# local to the current scope. Thread local.
alias $LAST_READ_LINE          $_

# The destination of output for Kernel#print
# and Kernel#printf. The default value is
# <code>$stdout</code>.
alias $DEFAULT_OUTPUT          $>

# An object that provides access to the concatenation
# of the contents of all the files
# given as command-line arguments, or <code>$stdin</code>
# (in the case where there are no
# arguments). <code>$<</code> supports methods similar to a
# File object:
# +inmode+, +close+,
# <code>closed?</code>, +each+,
# <code>each_byte</code>, <code>each_line</code>,
# +eof+, <code>eof?</code>, +file+,
# +filename+, +fileno+,
# +getc+, +gets+, +lineno+,
# <code>lineno=</code>, +path+,
# +pos+, <code>pos=</code>,
# +read+, +readchar+,
# +readline+, +readlines+,
# +rewind+, +seek+, +skip+,
# +tell+, <code>to_a</code>, <code>to_i</code>,
# <code>to_io</code>, <code>to_s</code>, along with the
# methods in Enumerable. The method +file+
# returns a File object for the file currently
# being read. This may change as <code>$<</code> reads
# through the files on the command line. Read only.
alias $DEFAULT_INPUT           $<

# The process number of the program being executed. Read only.
alias $PID                     $$
alias $PROCESS_ID              $$

# The exit status of the last child process to terminate. Read
# only. Thread local.
alias $CHILD_STATUS            $?

# A +MatchData+ object that encapsulates the results of a successful
# pattern match. The variables <code>$&</code>, <code>$`</code>, <code>$'</code>,
# and <code>$1</code> to <code>$9</code> are all derived from
# <code>$~</code>. Assigning to <code>$~</code> changes the values of these
# derived variables.  This variable is local to the current
# scope.
alias $LAST_MATCH_INFO         $~

# An array of strings containing the command-line
# options from the invocation of the program. Options
# used by the Ruby interpreter will have been
# removed. Read only. Also known simply as +ARGV+.
alias $ARGV                    $*

# The string matched by the last successful pattern
# match. This variable is local to the current
# scope. Read only.
alias $MATCH                   $&

# The string preceding the match in the last
# successful pattern match. This variable is local to
# the current scope. Read only.
alias $PREMATCH                $`

# The string following the match in the last
# successful pattern match. This variable is local to
# the current scope. Read only.
alias $POSTMATCH               $'

# The contents of the highest-numbered group matched in the last
# successful pattern match. Thus, in <code>"cat" =~ /(c|a)(t|z)/</code>,
# <code>$+</code> will be set to "t".  This variable is local to the
# current scope. Read only.
alias $LAST_PAREN_MATCH        $+
