/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.internal.WholeNumbers;

public class Shorts
extends Numbers<Short>
implements WholeNumbers<Short> {
    private static final Shorts INSTANCE = new Shorts(StandardComparisonStrategy.instance());

    public static Shorts instance() {
        return INSTANCE;
    }

    public Shorts(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Short zero() {
        return (short)0;
    }

    @Override
    protected Short one() {
        return (short)1;
    }

    @Override
    protected Short absDiff(Short actual, Short other) {
        return (short)Math.abs(other - actual);
    }

    @Override
    protected boolean isGreaterThan(Short value, Short other) {
        return value > other;
    }

    @Override
    public boolean isEven(Short number) {
        return (number & this.one()) == this.zero();
    }
}

