/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

public class QueryStringUtils {
    public static final String LUCENE_SPECIAL_CHARS = "+-&|!(){}[]^\"~:/";

    public static String escapeFieldName(String fieldName) {
        return fieldName.replace(" ", "\\ ");
    }

    public static String escapeLuceneSpecialCharacters(String text) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (LUCENE_SPECIAL_CHARS.indexOf(c) >= 0) {
                if ((c == '&' || c == '|') && i + 1 < text.length() && text.charAt(i + 1) == c) {
                    escaped.append('\\').append(c).append('\\').append(c);
                    ++i;
                    continue;
                }
                escaped.append('\\').append(c);
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

