/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlintIndexMetadataValidator {
    private static final Logger LOGGER = LogManager.getLogger(FlintIndexMetadataValidator.class);
    public static final Set<String> ALTER_TO_FULL_REFRESH_ALLOWED_OPTIONS = new LinkedHashSet<String>(Arrays.asList("auto_refresh", "incremental_refresh"));
    public static final Set<String> ALTER_TO_INCREMENTAL_REFRESH_ALLOWED_OPTIONS = new LinkedHashSet<String>(Arrays.asList("auto_refresh", "incremental_refresh", "watermark_delay", "checkpoint_location"));

    public static void validateFlintIndexOptions(String kind, Map<String, Object> existingOptions, Map<String, String> newOptions) {
        if (newOptions.containsKey("incremental_refresh") && Boolean.parseBoolean(newOptions.get("incremental_refresh")) || !newOptions.containsKey("incremental_refresh") && Boolean.parseBoolean((String)existingOptions.get("incremental_refresh"))) {
            FlintIndexMetadataValidator.validateConversionToIncrementalRefresh(kind, existingOptions, newOptions);
        } else {
            FlintIndexMetadataValidator.validateConversionToFullRefresh(newOptions);
        }
    }

    private static void validateConversionToFullRefresh(Map<String, String> newOptions) {
        if (!ALTER_TO_FULL_REFRESH_ALLOWED_OPTIONS.containsAll(newOptions.keySet())) {
            throw new IllegalArgumentException(String.format("Altering to full refresh only allows: %s options", ALTER_TO_FULL_REFRESH_ALLOWED_OPTIONS));
        }
    }

    private static void validateConversionToIncrementalRefresh(String kind, Map<String, Object> existingOptions, Map<String, String> newOptions) {
        if (!ALTER_TO_INCREMENTAL_REFRESH_ALLOWED_OPTIONS.containsAll(newOptions.keySet())) {
            throw new IllegalArgumentException(String.format("Altering to incremental refresh only allows: %s options", ALTER_TO_INCREMENTAL_REFRESH_ALLOWED_OPTIONS));
        }
        HashMap<String, Object> mergedOptions = new HashMap<String, Object>();
        mergedOptions.putAll(existingOptions);
        mergedOptions.putAll(newOptions);
        ArrayList<String> missingAttributes = new ArrayList<String>();
        if (!mergedOptions.containsKey("checkpoint_location") || StringUtils.isEmpty((String)mergedOptions.get("checkpoint_location"))) {
            missingAttributes.add("checkpoint_location");
        }
        if (kind.equals("mv") && (!mergedOptions.containsKey("watermark_delay") || StringUtils.isEmpty((String)mergedOptions.get("watermark_delay")))) {
            missingAttributes.add("watermark_delay");
        }
        if (missingAttributes.size() > 0) {
            String errorMessage2 = "Conversion to incremental refresh index cannot proceed due to missing attributes: " + String.join((CharSequence)", ", missingAttributes) + ".";
            LOGGER.error(errorMessage2);
            throw new IllegalArgumentException(errorMessage2);
        }
    }
}

