/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.protocol.response.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.protocol.response.QueryResult;
import shaded.com.google.common.collect.ImmutableCollection;
import shaded.com.google.common.collect.ImmutableList;

public class FlatResponseBase {
    protected static final String INTERLINE_SEPARATOR = System.lineSeparator();
    private final QueryResult response;
    protected final String separator;
    private final List<String> headers;
    private final List<List<String>> data;

    FlatResponseBase(QueryResult response, String separator) {
        this.response = response;
        this.separator = separator;
        this.headers = this.getOriginalHeaders(response);
        this.data = this.getOriginalData(response);
    }

    public String format() {
        ArrayList<String> headersAndData = new ArrayList<String>();
        headersAndData.add(this.getHeaderLine());
        headersAndData.addAll(this.getDataLines());
        return String.join((CharSequence)INTERLINE_SEPARATOR, headersAndData);
    }

    protected String getHeaderLine() {
        return String.join((CharSequence)this.separator, this.headers);
    }

    private List<String> getOriginalHeaders(QueryResult response) {
        ImmutableList.Builder headers = ImmutableList.builder();
        response.columnNameTypes().forEach((column, type2) -> headers.add(column));
        ImmutableCollection result2 = headers.build();
        return this.formatHeaders((List<String>)((Object)result2));
    }

    protected List<String> getDataLines() {
        return this.data.stream().map(v -> String.join((CharSequence)this.separator, v)).collect(Collectors.toList());
    }

    private List<List<String>> getOriginalData(QueryResult response) {
        ImmutableList.Builder dataLines = new ImmutableList.Builder();
        response.iterator().forEachRemaining(row -> {
            ImmutableList.Builder line = new ImmutableList.Builder();
            Arrays.asList(row).forEach(val -> line.add(val == null ? "" : val.toString()));
            dataLines.add(line.build());
        });
        ImmutableCollection result2 = dataLines.build();
        return this.formatData((List<List<String>>)((Object)result2));
    }

    protected List<String> formatHeaders(List<String> headers) {
        return headers.stream().map(cell -> this.quoteIfRequired(this.separator, (String)cell)).collect(Collectors.toList());
    }

    protected List<List<String>> formatData(List<List<String>> lines) {
        ArrayList<List<String>> result2 = new ArrayList<List<String>>();
        for (List<String> line : lines) {
            result2.add(line.stream().map(cell -> this.quoteIfRequired(this.separator, (String)cell)).collect(Collectors.toList()));
        }
        return result2;
    }

    protected String quoteIfRequired(String separator, String cell) {
        String quote = "\"";
        if (cell.contains(separator) || cell.contains("\"") || cell.contains("\r") || cell.contains("\n")) {
            return "\"" + cell.replaceAll("\"", "\"\"") + "\"";
        }
        return cell;
    }

    @Generated
    public QueryResult getResponse() {
        return this.response;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public List<String> getHeaders() {
        return this.headers;
    }

    @Generated
    public List<List<String>> getData() {
        return this.data;
    }
}

