/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.execution;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.statement.Explain;
import org.opensearch.sql.ast.statement.Query;
import org.opensearch.sql.ast.statement.Statement;
import org.opensearch.sql.ast.tree.CloseCursor;
import org.opensearch.sql.ast.tree.FetchCursor;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.exception.UnsupportedCursorRequestException;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.QueryId;
import org.opensearch.sql.executor.QueryService;
import org.opensearch.sql.executor.QueryType;
import org.opensearch.sql.executor.execution.AbstractPlan;
import org.opensearch.sql.executor.execution.CommandPlan;
import org.opensearch.sql.executor.execution.ExplainPlan;
import org.opensearch.sql.executor.execution.QueryPlan;
import org.opensearch.sql.executor.pagination.CanPaginateVisitor;

public class QueryPlanFactory
extends AbstractNodeVisitor<AbstractPlan, Pair<ResponseListener<ExecutionEngine.QueryResponse>, ResponseListener<ExecutionEngine.ExplainResponse>>> {
    private final QueryService queryService;
    public static final ResponseListener<ExecutionEngine.QueryResponse> NO_CONSUMER_RESPONSE_LISTENER = new ResponseListener<ExecutionEngine.QueryResponse>(){

        @Override
        public void onResponse(ExecutionEngine.QueryResponse response) {
            throw new IllegalStateException("[BUG] query response should not sent to unexpected channel");
        }

        @Override
        public void onFailure(Exception e) {
            throw new IllegalStateException("[BUG] exception response should not sent to unexpected channel");
        }
    };

    public AbstractPlan create(Statement statement, ResponseListener<ExecutionEngine.QueryResponse> queryListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        return statement.accept(this, Pair.of(queryListener, explainListener));
    }

    public AbstractPlan create(String cursor, boolean isExplain, QueryType queryType, String format, ResponseListener<ExecutionEngine.QueryResponse> queryResponseListener, ResponseListener<ExecutionEngine.ExplainResponse> explainListener) {
        QueryId queryId = QueryId.queryId();
        QueryPlan plan = new QueryPlan(queryId, queryType, new FetchCursor(cursor), this.queryService, queryResponseListener);
        return isExplain ? new ExplainPlan(queryId, queryType, plan, Explain.format(format), explainListener) : plan;
    }

    boolean canConvertToCursor(UnresolvedPlan plan) {
        return plan.accept(new CanPaginateVisitor(), null);
    }

    public AbstractPlan createCloseCursor(String cursor, QueryType queryType, ResponseListener<ExecutionEngine.QueryResponse> queryResponseListener) {
        return new CommandPlan(QueryId.queryId(), queryType, new CloseCursor().attach(new FetchCursor(cursor)), this.queryService, queryResponseListener);
    }

    @Override
    public AbstractPlan visitQuery(Query node, Pair<ResponseListener<ExecutionEngine.QueryResponse>, ResponseListener<ExecutionEngine.ExplainResponse>> context) {
        Objects.requireNonNull(context.getLeft(), "[BUG] query listener must be not null");
        if (node.getFetchSize() > 0) {
            if (this.canConvertToCursor(node.getPlan())) {
                return new QueryPlan(QueryId.queryId(), node.getQueryType(), node.getPlan(), node.getFetchSize(), this.queryService, context.getLeft());
            }
            throw new UnsupportedCursorRequestException();
        }
        return new QueryPlan(QueryId.queryId(), node.getQueryType(), node.getPlan(), this.queryService, context.getLeft());
    }

    @Override
    public AbstractPlan visitExplain(Explain node, Pair<ResponseListener<ExecutionEngine.QueryResponse>, ResponseListener<ExecutionEngine.ExplainResponse>> context) {
        Objects.requireNonNull(context.getRight(), "[BUG] explain listener must be not null");
        return new ExplainPlan(QueryId.queryId(), node.getQueryType(), this.create(node.getStatement(), NO_CONSUMER_RESPONSE_LISTENER, context.getRight()), node.getFormat(), context.getRight());
    }

    @Generated
    public QueryPlanFactory(QueryService queryService) {
        this.queryService = queryService;
    }
}

