/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import java.util.List;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.collect.ImmutableList;

public class OracleSqlDialect
extends SqlDialect {
    private static final RelDataTypeSystem ORACLE_TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case VARCHAR: {
                    return 4000;
                }
            }
            return super.getMaxPrecision(typeName);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.ORACLE).withIdentifierQuoteString("\"").withDataTypeSystem(ORACLE_TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new OracleSqlDialect(DEFAULT_CONTEXT);
    private final int majorVersion;

    public OracleSqlDialect(SqlDialect.Context context) {
        super(context);
        this.majorVersion = context.databaseMajorVersion();
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean supportBooleanCaseWhen() {
        return this.majorVersion >= 23;
    }

    @Override
    public boolean supportsDataType(RelDataType type2) {
        switch (type2.getSqlTypeName()) {
            case BOOLEAN: {
                return false;
            }
        }
        return super.supportsDataType(type2);
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type2) {
        String castSpec;
        switch (type2.getSqlTypeName()) {
            case SMALLINT: {
                castSpec = "NUMBER(5)";
                break;
            }
            case INTEGER: {
                castSpec = "NUMBER(10)";
                break;
            }
            case BIGINT: {
                castSpec = "NUMBER(19)";
                break;
            }
            case DOUBLE: {
                castSpec = "DOUBLE PRECISION";
                break;
            }
            default: {
                return super.getCastSpec(type2);
            }
        }
        return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec(castSpec, type2.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseBoolLiteral(SqlWriter writer, SqlLiteral literal, int leftPrec, int rightPrec) {
        Boolean value = (Boolean)literal.getValue();
        if (value == null || this.majorVersion >= 23) {
            super.unparseBoolLiteral(writer, literal, leftPrec, rightPrec);
            return;
        }
        SqlWriter.Frame frame = writer.startList("(", ")");
        writer.literal("1");
        writer.sep(SqlStdOperatorTable.EQUALS.getName());
        writer.literal(value != false ? "1" : "0");
        writer.endList(frame);
    }

    @Override
    public void unparseDateTimeLiteral(SqlWriter writer, SqlAbstractDateTimeLiteral literal, int leftPrec, int rightPrec) {
        if (literal instanceof SqlTimestampLiteral) {
            writer.literal("TO_TIMESTAMP('" + literal.toFormattedString() + "', 'YYYY-MM-DD HH24:MI:SS.FF')");
        } else if (literal instanceof SqlDateLiteral) {
            writer.literal("TO_DATE('" + literal.toFormattedString() + "', 'YYYY-MM-DD')");
        } else if (literal instanceof SqlTimeLiteral) {
            writer.literal("TO_TIME('" + literal.toFormattedString() + "', 'HH24:MI:SS.FF')");
        } else {
            super.unparseDateTimeLiteral(writer, literal, leftPrec, rightPrec);
        }
    }

    @Override
    public List<String> getSingleRowTableName() {
        return ImmutableList.of("DUAL");
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            SqlUtil.unparseFunctionSyntax(SqlLibraryOperators.SUBSTR_ORACLE, writer, call, false);
        } else {
            switch (call.getKind()) {
                case POSITION: {
                    SqlWriter.Frame frame = writer.startFunCall("INSTR");
                    writer.sep(",");
                    ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                    writer.sep(",");
                    ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                    if (3 == call.operandCount()) {
                        writer.sep(",");
                        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
                    }
                    if (4 == call.operandCount()) {
                        writer.sep(",");
                        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
                        writer.sep(",");
                        ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
                    }
                    writer.endFunCall(frame);
                    break;
                }
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "TRUNC", true);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        if (this.majorVersion != -1 && this.majorVersion < 12) {
            throw new RuntimeException("Lower Oracle version(<12) doesn't support offset/fetch syntax!");
        }
        super.unparseOffsetFetch(writer, offset, fetch);
    }
}

