/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class CallableUtils {
    private CallableUtils() {
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, Function<T, R> resultHandler) {
        return () -> resultHandler.apply(callable.call());
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, BiFunction<T, Throwable, R> handler) {
        return () -> {
            try {
                Object result2 = callable.call();
                return handler.apply(result2, null);
            }
            catch (Exception exception) {
                return handler.apply(null, exception);
            }
        };
    }

    public static <T, R> Callable<R> andThen(Callable<T> callable, Function<T, R> resultHandler, Function<Throwable, R> exceptionHandler) {
        return () -> {
            try {
                Object result2 = callable.call();
                return resultHandler.apply(result2);
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }

    public static <T> Callable<T> recover(Callable<T> callable, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                return exceptionHandler.apply(exception);
            }
        };
    }

    public static <T> Callable<T> recover(Callable<T> callable, Predicate<T> resultPredicate, UnaryOperator<T> resultHandler) {
        return () -> {
            Object result2 = callable.call();
            if (resultPredicate.test(result2)) {
                return resultHandler.apply(result2);
            }
            return result2;
        };
    }

    public static <T> Callable<T> recover(Callable<T> callable, List<Class<? extends Throwable>> exceptionTypes, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                if (exceptionTypes.stream().anyMatch(exceptionType -> exceptionType.isAssignableFrom(exception.getClass()))) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }

    public static <X extends Throwable, T> Callable<T> recover(Callable<T> callable, Class<X> exceptionType, Function<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                if (exceptionType.isAssignableFrom(exception.getClass())) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }
}

