/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.emrserverless.model.transform.NetworkConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> subnetIds;
    private List<String> securityGroupIds;

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new ArrayList<String>(subnetIds);
    }

    public NetworkConfiguration withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add(ele);
        }
        return this;
    }

    public NetworkConfiguration withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public NetworkConfiguration withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public NetworkConfiguration withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds()).append(",");
        }
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration)obj;
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        return other.getSecurityGroupIds() == null || other.getSecurityGroupIds().equals(this.getSecurityGroupIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode2 = 1;
        hashCode2 = 31 * hashCode2 + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode2 = 31 * hashCode2 + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        return hashCode2;
    }

    public NetworkConfiguration clone() {
        try {
            return (NetworkConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

