/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.waiters.ClusterRunning;
import com.amazonaws.services.elasticmapreduce.waiters.ClusterTerminated;
import com.amazonaws.services.elasticmapreduce.waiters.DescribeClusterFunction;
import com.amazonaws.services.elasticmapreduce.waiters.DescribeStepFunction;
import com.amazonaws.services.elasticmapreduce.waiters.StepComplete;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonElasticMapReduceWaiters {
    private final AmazonElasticMapReduce client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonElasticMapReduceWaiters");

    @SdkInternalApi
    public AmazonElasticMapReduceWaiters(AmazonElasticMapReduce client) {
        this.client = client;
    }

    public Waiter<DescribeClusterRequest> clusterRunning() {
        return new WaiterBuilder<DescribeClusterRequest, DescribeClusterResult>().withSdkFunction(new DescribeClusterFunction(this.client)).withAcceptors(new ClusterRunning.IsRUNNINGMatcher(), new ClusterRunning.IsWAITINGMatcher(), new ClusterRunning.IsTERMINATINGMatcher(), new ClusterRunning.IsTERMINATEDMatcher(), new ClusterRunning.IsTERMINATED_WITH_ERRORSMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeStepRequest> stepComplete() {
        return new WaiterBuilder<DescribeStepRequest, DescribeStepResult>().withSdkFunction(new DescribeStepFunction(this.client)).withAcceptors(new StepComplete.IsCOMPLETEDMatcher(), new StepComplete.IsFAILEDMatcher(), new StepComplete.IsCANCELLEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterRequest> clusterTerminated() {
        return new WaiterBuilder<DescribeClusterRequest, DescribeClusterResult>().withSdkFunction(new DescribeClusterFunction(this.client)).withAcceptors(new ClusterTerminated.IsTERMINATEDMatcher(), new ClusterTerminated.IsTERMINATED_WITH_ERRORSMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

