/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.builder.impl;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.builder.SQLUpdateBuilder;
import com.alibaba.druid.sql.builder.impl.SQLBuilderImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import java.util.List;
import java.util.Map;

public class SQLUpdateBuilderImpl
extends SQLBuilderImpl
implements SQLUpdateBuilder {
    private SQLUpdateStatement stmt;
    private String dbType;

    public SQLUpdateBuilderImpl(String dbType) {
        this.dbType = dbType;
    }

    public SQLUpdateBuilderImpl(String sql, String dbType) {
        SQLUpdateStatement stmt;
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, dbType);
        if (stmtList.size() == 0) {
            throw new IllegalArgumentException("not support empty-statement :" + sql);
        }
        if (stmtList.size() > 1) {
            throw new IllegalArgumentException("not support multi-statement :" + sql);
        }
        this.stmt = stmt = (SQLUpdateStatement)stmtList.get(0);
        this.dbType = dbType;
    }

    public SQLUpdateBuilderImpl(SQLUpdateStatement stmt, String dbType) {
        this.stmt = stmt;
        this.dbType = dbType;
    }

    @Override
    public SQLUpdateBuilderImpl limit(int rowCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLUpdateBuilderImpl limit(int rowCount, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLUpdateBuilderImpl from(String table) {
        return this.from(table, null);
    }

    @Override
    public SQLUpdateBuilderImpl from(String table, String alias) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        SQLExprTableSource from = new SQLExprTableSource(new SQLIdentifierExpr(table), alias);
        update.setTableSource(from);
        return this;
    }

    @Override
    public SQLUpdateBuilderImpl where(String expr) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        update.setWhere(exprObj);
        return this;
    }

    @Override
    public SQLUpdateBuilderImpl whereAnd(String expr) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanAnd, exprObj, false, update.getWhere());
        update.setWhere(newCondition);
        return this;
    }

    @Override
    public SQLUpdateBuilderImpl whereOr(String expr) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        SQLExpr exprObj = SQLUtils.toSQLExpr(expr, this.dbType);
        SQLExpr newCondition = SQLUtils.buildCondition(SQLBinaryOperator.BooleanOr, exprObj, false, update.getWhere());
        update.setWhere(newCondition);
        return this;
    }

    @Override
    public SQLUpdateBuilderImpl set(String ... items) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        for (String item : items) {
            SQLUpdateSetItem updateSetItem = SQLUtils.toUpdateSetItem(item, this.dbType);
            update.addItem(updateSetItem);
        }
        return this;
    }

    public SQLUpdateBuilderImpl setValue(Map<String, Object> values2) {
        for (Map.Entry<String, Object> entry : values2.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SQLUpdateBuilderImpl setValue(String column, Object value) {
        SQLUpdateStatement update = this.getSQLUpdateStatement();
        SQLExpr columnExpr = SQLUtils.toSQLExpr(column, this.dbType);
        SQLExpr valueExpr = SQLUpdateBuilderImpl.toSQLExpr(value, this.dbType);
        SQLUpdateSetItem item = new SQLUpdateSetItem();
        item.setColumn(columnExpr);
        item.setValue(valueExpr);
        update.addItem(item);
        return this;
    }

    public SQLUpdateStatement getSQLUpdateStatement() {
        if (this.stmt == null) {
            this.stmt = this.createSQLUpdateStatement();
        }
        return this.stmt;
    }

    public SQLUpdateStatement createSQLUpdateStatement() {
        if ("mysql".equals(this.dbType)) {
            return new MySqlUpdateStatement();
        }
        if ("oracle".equals(this.dbType)) {
            return new OracleUpdateStatement();
        }
        if ("postgresql".equals(this.dbType)) {
            return new PGUpdateStatement();
        }
        if ("sqlserver".equals(this.dbType)) {
            return new SQLServerUpdateStatement();
        }
        return new SQLUpdateStatement();
    }

    public String toString() {
        return SQLUtils.toSQLString(this.stmt, this.dbType);
    }
}

