/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.Ids;

public class CacheBiConsumers {
    private CacheBiConsumers() {
    }

    static <K, V, R> Consumer<R> objectConsumer(BiConsumer<Cache<K, V>, ? super R> biConsumer) {
        return new CacheObjBiConsumer<K, V, R>(biConsumer);
    }

    static <K, V> DoubleConsumer doubleConsumer(ObjDoubleConsumer<Cache<K, V>> objDoubleConsumer) {
        return new CacheDoubleConsumer<K, V>(objDoubleConsumer);
    }

    static <K, V> LongConsumer longConsumer(ObjLongConsumer<Cache<K, V>> objLongConsumer) {
        return new CacheLongConsumer<K, V>(objLongConsumer);
    }

    static <K, V> IntConsumer intConsumer(ObjIntConsumer<Cache<K, V>> objIntConsumer) {
        return new CacheIntConsumer<K, V>(objIntConsumer);
    }

    @Scope(value=Scopes.NONE)
    static class CacheObjBiConsumer<K, V, R>
    implements Consumer<R> {
        private final BiConsumer<Cache<K, V>, ? super R> biConsumer;
        protected transient Cache<K, V> cache;

        @Inject
        void inject(Cache<K, V> cache, ComponentRegistry componentRegistry) {
            componentRegistry.wireDependencies(this.biConsumer);
            this.cache = cache;
        }

        CacheObjBiConsumer(BiConsumer<Cache<K, V>, ? super R> biConsumer) {
            this.biConsumer = biConsumer;
        }

        @Override
        public void accept(R r) {
            this.biConsumer.accept(this.cache, r);
        }
    }

    @Scope(value=Scopes.NONE)
    static class CacheDoubleConsumer<K, V>
    implements DoubleConsumer {
        private final ObjDoubleConsumer<Cache<K, V>> objDoubleConsumer;
        protected transient Cache<K, V> cache;

        @Inject
        void inject(Cache<K, V> cache, ComponentRegistry componentRegistry) {
            componentRegistry.wireDependencies(this.objDoubleConsumer);
            this.cache = cache;
        }

        CacheDoubleConsumer(ObjDoubleConsumer<Cache<K, V>> objDoubleConsumer) {
            this.objDoubleConsumer = objDoubleConsumer;
        }

        @Override
        public void accept(double r) {
            this.objDoubleConsumer.accept(this.cache, r);
        }
    }

    @Scope(value=Scopes.NONE)
    static class CacheLongConsumer<K, V>
    implements LongConsumer {
        private final ObjLongConsumer<Cache<K, V>> objLongConsumer;
        protected transient Cache<K, V> cache;

        @Inject
        void inject(Cache<K, V> cache, ComponentRegistry componentRegistry) {
            componentRegistry.wireDependencies(this.objLongConsumer);
            this.cache = cache;
        }

        CacheLongConsumer(ObjLongConsumer<Cache<K, V>> objLongConsumer) {
            this.objLongConsumer = objLongConsumer;
        }

        @Override
        public void accept(long r) {
            this.objLongConsumer.accept(this.cache, r);
        }
    }

    @Scope(value=Scopes.NONE)
    static class CacheIntConsumer<K, V>
    implements IntConsumer {
        private final ObjIntConsumer<Cache<K, V>> objIntConsumer;
        protected transient Cache<K, V> cache;

        @Inject
        void inject(Cache<K, V> cache, ComponentRegistry componentRegistry) {
            componentRegistry.wireDependencies(this.objIntConsumer);
            this.cache = cache;
        }

        CacheIntConsumer(ObjIntConsumer<Cache<K, V>> objIntConsumer) {
            this.objIntConsumer = objIntConsumer;
        }

        @Override
        public void accept(int r) {
            this.objIntConsumer.accept(this.cache, r);
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<Object> {
        private static final ExternalizerId[] VALUES = ExternalizerId.values();
        private final Map<Class<?>, ExternalizerId> objects = new HashMap();

        public Externalizer() {
            for (ExternalizerId id : VALUES) {
                this.objects.put(id.marshalledClass, id);
            }
        }

        public Set<Class<?>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{CacheObjBiConsumer.class, CacheDoubleConsumer.class, CacheLongConsumer.class, CacheIntConsumer.class});
        }

        public Integer getId() {
            return Ids.CACHE_BI_CONSUMERS;
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            ExternalizerId id = this.objects.get(object.getClass());
            if (id == null) {
                throw new IllegalArgumentException("Unsupported class " + String.valueOf(object.getClass()) + " was provided!");
            }
            output.writeByte(id.ordinal());
            switch (id.ordinal()) {
                case 0: {
                    output.writeObject(((CacheObjBiConsumer)object).biConsumer);
                    break;
                }
                case 1: {
                    output.writeObject(((CacheDoubleConsumer)object).objDoubleConsumer);
                    break;
                }
                case 2: {
                    output.writeObject(((CacheLongConsumer)object).objLongConsumer);
                    break;
                }
                case 3: {
                    output.writeObject(((CacheIntConsumer)object).objIntConsumer);
                }
            }
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            ExternalizerId[] ids;
            int number = input.readUnsignedByte();
            if (number >= (ids = VALUES).length) {
                throw new IllegalArgumentException("Found invalid number " + number);
            }
            ExternalizerId id = ids[number];
            switch (id.ordinal()) {
                case 0: {
                    return new CacheObjBiConsumer((BiConsumer)input.readObject());
                }
                case 1: {
                    return new CacheDoubleConsumer((ObjDoubleConsumer)input.readObject());
                }
                case 2: {
                    return new CacheLongConsumer((ObjLongConsumer)input.readObject());
                }
                case 3: {
                    return new CacheIntConsumer((ObjIntConsumer)input.readObject());
                }
            }
            throw new IllegalArgumentException("ExternalizerId not supported: " + String.valueOf((Object)id));
        }

        static enum ExternalizerId {
            OBJECT(CacheObjBiConsumer.class),
            DOUBLE(CacheDoubleConsumer.class),
            LONG(CacheLongConsumer.class),
            INT(CacheIntConsumer.class);

            private final Class<?> marshalledClass;

            private ExternalizerId(Class<?> marshalledClass) {
                this.marshalledClass = marshalledClass;
            }
        }
    }
}

