/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.PomHashValue;

public class PomHashMap
implements Serializable {
    @NotNull
    private final @NotNull Map<@NotNull File, @NotNull PomHashValue> pomMap = new HashMap<File, PomHashValue>();
    @NotNull
    private final @NotNull Map<@NotNull File, @NotNull HashSet<@NotNull File>> pomDependencies = new HashMap<File, HashSet<File>>();

    public void put(@NotNull File pom, @Nullable String dependencyHash) {
        if (pom == null) {
            PomHashMap.$$$reportNull$$$0(0);
        }
        this.pomMap.put(pom, new PomHashValue(dependencyHash));
    }

    public void addFileDependency(@NotNull File pom, @NotNull File dependentPom) {
        if (pom == null) {
            PomHashMap.$$$reportNull$$$0(1);
        }
        if (dependentPom == null) {
            PomHashMap.$$$reportNull$$$0(2);
        }
        this.pomDependencies.putIfAbsent(pom, new HashSet());
        this.pomDependencies.get(pom).add(dependentPom);
    }

    public void addFileDependencies(@NotNull File pom, @NotNull @NotNull Collection<@NotNull File> dependentPoms) {
        if (pom == null) {
            PomHashMap.$$$reportNull$$$0(3);
        }
        if (dependentPoms == null) {
            PomHashMap.$$$reportNull$$$0(4);
        }
        for (File dependentPom : dependentPoms) {
            this.addFileDependency(pom, dependentPom);
        }
    }

    @NotNull
    public @NotNull Set<@NotNull File> getFileDependencies(@NotNull File pom) {
        Set dependencies;
        if (pom == null) {
            PomHashMap.$$$reportNull$$$0(5);
        }
        Set set = (dependencies = (Set)this.pomDependencies.get(pom)) == null ? Collections.emptySet() : dependencies;
        if (set == null) {
            PomHashMap.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public @NotNull Set<@NotNull File> keySet() {
        Set<File> set = this.pomMap.keySet();
        if (set == null) {
            PomHashMap.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    public String getDependencyHash(@NotNull File file) {
        PomHashValue data;
        if (file == null) {
            PomHashMap.$$$reportNull$$$0(8);
        }
        return null == (data = this.pomMap.get(file)) ? null : data.getDependencyHash();
    }

    public boolean isEmpty() {
        return this.pomMap.isEmpty();
    }

    public int size() {
        return this.pomMap.size();
    }

    public String toString() {
        return this.pomMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pom";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPom";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPoms";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/PomHashMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/PomHashMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFileDependency";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileDependencies";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyHash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

