/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.consts;

import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;

public class LinkConstant
extends PooledConstant {
    public int index1;
    public int index2;
    public String className;
    public String elementName;
    public String descriptor;

    public LinkConstant(int type, String className, String elementName, String descriptor) {
        super(type);
        this.className = className;
        this.elementName = elementName;
        this.descriptor = descriptor;
        this.initConstant();
    }

    public LinkConstant(int type, int index1, int index2) {
        super(type);
        this.index1 = index1;
        this.index2 = index2;
    }

    private void initConstant() {
        if (this.type == 10 || this.type == 11 || this.type == 18 || this.type == 15 && this.index1 != 1 && this.index1 != 3) {
            int parenth = this.descriptor.indexOf(41);
            if (this.descriptor.length() < 2 || parenth < 0 || this.descriptor.charAt(0) != '(') {
                throw new IllegalArgumentException("Invalid descriptor: " + this.descriptor + "; type = " + this.type + "; className = " + this.className + "; elementName = " + this.elementName);
            }
        }
    }

    @Override
    public void resolveConstant(ConstantPool pool) {
        if (this.type == 12) {
            this.elementName = pool.getPrimitiveConstant(this.index1).getString();
            this.descriptor = pool.getPrimitiveConstant(this.index2).getString();
        } else if (this.type == 15) {
            LinkConstant ref_info = pool.getLinkConstant(this.index2);
            this.className = ref_info.className;
            this.elementName = ref_info.elementName;
            this.descriptor = ref_info.descriptor;
        } else {
            if (this.type != 18 && this.type != 17) {
                this.className = pool.getPrimitiveConstant(this.index1).getString();
            }
            LinkConstant nameType = pool.getLinkConstant(this.index2);
            this.elementName = nameType.elementName;
            this.descriptor = nameType.descriptor;
        }
        this.initConstant();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkConstant)) {
            return false;
        }
        LinkConstant cn = (LinkConstant)o;
        return this.type == cn.type && this.elementName.equals(cn.elementName) && this.descriptor.equals(cn.descriptor) && (this.type != 12 || this.className.equals(cn.className));
    }

    public String toString() {
        return (String)(this.className == null ? "" : this.className + ".") + this.elementName + this.descriptor;
    }
}

