/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GotoRowAction
extends AnAction
implements DumbAware {
    public static final String GO_TO_ROW_EXECUTOR_KEY = "GoToRowExecutor";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GotoRowAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            GotoRowAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            GotoRowAction.showGoToDialog(dataGrid);
        }
    }

    public static void showGoToDialog(DataGrid dataGrid) {
        GoToRowHelper executor = (GoToRowHelper)ObjectUtils.tryCast((Object)dataGrid.getResultView().getComponent().getClientProperty(GO_TO_ROW_EXECUTOR_KEY), GoToRowHelper.class);
        if (executor == null) {
            return;
        }
        GotoRowDialog dialog = new GotoRowDialog(dataGrid, executor);
        dialog.show();
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid resultPanel;
        if (e == null) {
            GotoRowAction.$$$reportNull$$$0(2);
        }
        JComponent component = (resultPanel = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null ? null : resultPanel.getResultView().getComponent();
        boolean enabled = component != null && ObjectUtils.tryCast((Object)component.getClientProperty(GO_TO_ROW_EXECUTOR_KEY), GoToRowHelper.class) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/GotoRowAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/GotoRowAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface GoToRowHelper {
        public void goToRow(@NotNull String var1, @NotNull String var2);
    }

    private static class GotoRowDialog
    extends DialogWrapper {
        private JTextField myField;
        private final GoToRowHelper myExecutor;

        GotoRowDialog(DataGrid dataGrid, GoToRowHelper executor) {
            super((Component)dataGrid.getPreferredFocusedComponent(), true);
            this.myExecutor = executor;
            this.setTitle(DataGridBundle.message((String)"dialog.title.go.to.row", (Object[])new Object[0]));
            this.init();
        }

        protected void doOKAction() {
            String text = this.getText();
            int idx = GotoRowDialog.separatorIndex(text);
            String row = idx == -1 ? text : text.substring(0, idx).trim();
            String column = idx == -1 ? "" : text.substring(idx + 1).trim();
            this.myExecutor.goToRow(row, column);
            super.doOKAction();
        }

        private static int separatorIndex(String text) {
            int colonIndex = text.indexOf(58);
            return colonIndex >= 0 ? colonIndex : text.indexOf(44);
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JTextField jTextField = this.myField;
            if (jTextField == null) {
                GotoRowDialog.$$$reportNull$$$0(0);
            }
            return jTextField;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        private String getText() {
            return this.myField.getText();
        }

        protected JComponent createNorthPanel() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)8, (int)4);
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel label = new JLabel(DataGridBundle.message((String)"row.column", (Object[])new Object[0]));
            panel2.add((Component)label, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            class MyTextField
            extends JTextField {
                MyTextField() {
                    super("");
                }

                @Override
                @NotNull
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    return new Dimension(200, d.height);
                }
            }
            this.myField = new MyTextField();
            panel2.add((Component)this.myField, gbConstraints);
            this.myField.setToolTipText(StringUtil.escapeXmlEntities((String)DataGridBundle.message((String)"row.column.or.row.column", (Object[])new Object[0])));
            return panel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getPreferredFocusedComponent"));
        }
    }
}

