/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.ConstructorDelegationKind;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SharedVariablesLowering;
import org.jetbrains.kotlin.backend.common.lower.VisibilityPolicy;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmEvaluatorData;
import org.jetbrains.kotlin.backend.jvm.lower.FunctionReferenceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.JvmVisibilityPolicy;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.SmartList;

@PhaseDescription(name="JvmLocalDeclarations", prerequisite={FunctionReferenceLowering.class, SharedVariablesLowering.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0010H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLocalDeclarationsLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "getReplacementSymbolForCaptured", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "symbol", "getConstructorsThatCouldCaptureParamsWithoutFieldCreating", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmLocalDeclarationsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLocalDeclarationsLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n*L\n1#1,102:1\n369#2,7:103\n32#3,2:110\n9#3,6:112\n*S KotlinDebug\n*F\n+ 1 JvmLocalDeclarationsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLocalDeclarationsLowering\n*L\n52#1:103,7\n69#1:110,2\n69#1:112,6\n*E\n"})
public final class JvmLocalDeclarationsLowering
extends LocalDeclarationsLowering {
    @NotNull
    private final JvmBackendContext context;

    public JvmLocalDeclarationsLowering(@NotNull JvmBackendContext context2) {
        Map map;
        Map map2;
        Map map3;
        Map map4;
        Intrinsics.checkNotNullParameter(context2, "context");
        LoweringContext loweringContext = context2;
        Function1 function1 = new Function1<String, String>((Object)NameUtils.INSTANCE){

            @Override
            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return NameUtils.sanitizeAsJavaIdentifier(p0);
            }
        };
        VisibilityPolicy visibilityPolicy = JvmVisibilityPolicy.INSTANCE;
        Set<IrConstructor> set = context2.getAllConstructorsWithCapturedConstructorCreated();
        Object object = context2.getEvaluatorData();
        if (object == null || (object = ((JvmEvaluatorData)object).getLocalDeclarationsData()) == null || (object = ((JvmBackendContext.SharedLocalDeclarationsData)object).getClosureBuilders()) == null) {
            object = new LinkedHashMap();
        }
        if ((map4 = context2.getEvaluatorData()) == null || (map4 = ((JvmEvaluatorData)((Object)map4)).getLocalDeclarationsData()) == null || (map4 = ((JvmBackendContext.SharedLocalDeclarationsData)((Object)map4)).getTransformedDeclarations()) == null) {
            map4 = new LinkedHashMap();
        }
        if ((map3 = context2.getEvaluatorData()) == null || (map3 = ((JvmEvaluatorData)((Object)map3)).getLocalDeclarationsData()) == null || (map3 = ((JvmBackendContext.SharedLocalDeclarationsData)((Object)map3)).getNewParameterToCaptured()) == null) {
            map3 = new LinkedHashMap();
        }
        if ((map2 = context2.getEvaluatorData()) == null || (map2 = ((JvmEvaluatorData)((Object)map2)).getLocalDeclarationsData()) == null || (map2 = ((JvmBackendContext.SharedLocalDeclarationsData)((Object)map2)).getNewParameterToOld()) == null) {
            map2 = new LinkedHashMap();
        }
        if ((map = context2.getEvaluatorData()) == null || (map = ((JvmEvaluatorData)((Object)map)).getLocalDeclarationsData()) == null || (map = ((JvmBackendContext.SharedLocalDeclarationsData)((Object)map)).getOldParameterToNew()) == null) {
            map = new LinkedHashMap();
        }
        super(loweringContext, function1, visibilityPolicy, false, true, true, false, set, (Map)object, map4, map3, map2, map, 8, null);
        this.context = context2;
    }

    @Override
    @NotNull
    public JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public IrValueSymbol getReplacementSymbolForCaptured(@NotNull IrDeclaration container, @NotNull IrValueSymbol symbol) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        JvmEvaluatorData jvmEvaluatorData = this.getContext().getEvaluatorData();
        if (Intrinsics.areEqual(jvmEvaluatorData != null ? jvmEvaluatorData.getEvaluatorGeneratedFunction() : null, container) && !SequencesKt.contains(IrUtilsKt.getParentDeclarationsWithSelf(symbol.getOwner()), container)) {
            IrValueParameter irValueParameter;
            IrFunction $this$addValueParameter$iv = (IrFunction)container;
            boolean $i$f$addValueParameter = false;
            IrValueParameterBuilder $this$addValueParameter_u24lambda_u2435$iv = new IrValueParameterBuilder();
            boolean bl = false;
            IrValueParameterBuilder $this$getReplacementSymbolForCaptured_u24lambda_u240 = $this$addValueParameter_u24lambda_u2435$iv;
            boolean bl2 = false;
            $this$getReplacementSymbolForCaptured_u24lambda_u240.setType(symbol.getOwner().getType());
            $this$getReplacementSymbolForCaptured_u24lambda_u240.setName(symbol.getOwner().getName());
            $this$addValueParameter_u24lambda_u2435$iv.setKind(IrParameterKind.Regular);
            IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2435$iv, $this$addValueParameter$iv);
            boolean bl3 = false;
            $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), valueParameter$iv));
            IrValueParameter newParameter = irValueParameter;
            this.getContext().getState().getNewFragmentCaptureParameters().add(new Triple<String, KotlinType, DeclarationDescriptor>(symbol.getOwner().getName().asString(), IrBasedDescriptorsKt.toIrBasedKotlinType$default(symbol.getOwner().getType(), null, 1, null), IrBasedDescriptorsKt.toIrBasedDescriptor(symbol.getOwner())));
            return newParameter.getSymbol();
        }
        return symbol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Iterable<IrConstructor> getConstructorsThatCouldCaptureParamsWithoutFieldCreating(@NotNull IrClass $this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating) {
        List list;
        Intrinsics.checkNotNullParameter($this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating, "<this>");
        Collection $this$filterIsInstanceAnd$iv = $this$getConstructorsThatCouldCaptureParamsWithoutFieldCreating.getDeclarations();
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                IrConstructor it = (IrConstructor)element$iv$iv;
                boolean bl = false;
                if (!(LowerUtilsKt.delegationKind(it, this.getContext().getIrBuiltIns()) == ConstructorDelegationKind.CALLS_SUPER)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }
}

