/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.ByteWName;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.SingleByteXmlWriter;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class Latin1XmlWriter
extends SingleByteXmlWriter {
    static final int LAST_VALID_CHAR = 255;

    public Latin1XmlWriter(WriterConfig cfg, OutputStream out) {
        super(cfg, out, OutputCharTypes.getLatin1CharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 255;
    }

    @Override
    public void writeRaw(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null || len == 0) {
            return;
        }
        if (this._surrogate != 0) {
            this.outputSurrogates(this._surrogate, cbuf[offset]);
            ++offset;
            --len;
        }
        len += offset;
        while (offset < len) {
            char ch;
            if ((ch = cbuf[offset++]) > '\u00ff') {
                this.reportFailedEscaping("raw content", ch);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)ch;
        }
    }

    @Override
    protected WName doConstructName(String localName) throws XMLStreamException {
        return new ByteWName(localName, Latin1XmlWriter.getAscii(localName));
    }

    @Override
    protected WName doConstructName(String prefix, String localName) throws XMLStreamException {
        int plen = prefix.length();
        byte[] pname = new byte[plen + 1 + localName.length()];
        Latin1XmlWriter.getAscii(prefix, pname, 0);
        pname[plen] = 58;
        Latin1XmlWriter.getAscii(localName, pname, plen + 1);
        return new ByteWName(prefix, localName, pname);
    }
}

