/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.inputHandlers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.UnifiedNumberTypeOptions;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.Aggregator;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.AggregatorInputHandler;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.ValueType;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.ValueTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001 \u0001*\u0004\u0018\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J4\u0010\u0007\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t\u0012\u0004\u0012\u00020\n0\b2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tH\u0016R-\u0010\u0011\u001a\u0015\u0012\u0004\u0012\u00020\u0004\u0012\t\u0012\u00078\u0000\u00a2\u0006\u0002\b\u0013\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/inputHandlers/NumberInputHandler;", "Return", "", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/AggregatorInputHandler;", "", "<init>", "()V", "preprocessAggregation", "Lkotlin/Pair;", "Lkotlin/sequences/Sequence;", "Lkotlin/reflect/KType;", "values", "valueType", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/ValueType;", "calculateValueType", "valueTypes", "", "aggregator", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregator;", "Lkotlin/UnsafeVariance;", "getAggregator", "()Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregator;", "setAggregator", "(Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregator;)V", "core"})
@SourceDebugExtension(value={"SMAP\nNumberInputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberInputHandler.kt\norg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/inputHandlers/NumberInputHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1755#2,3:136\n*S KotlinDebug\n*F\n+ 1 NumberInputHandler.kt\norg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/inputHandlers/NumberInputHandler\n*L\n106#1:136,3\n*E\n"})
public final class NumberInputHandler<Return>
implements AggregatorInputHandler<Number, Return> {
    @Nullable
    private Aggregator<? super Number, ? extends Return> aggregator;

    @Override
    @NotNull
    public Pair<Sequence<Number>, KType> preprocessAggregation(@NotNull Sequence<? extends Number> values, @NotNull ValueType valueType) {
        Pair pair;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)valueType, (String)"valueType");
        if (!KTypes.isSubtypeOf((KType)valueType.getKType(), (KType)Reflection.nullableTypeOf(Number.class))) {
            boolean $i$a$-require-NumberInputHandler$preprocessAggregation$32 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Type ").append(valueType).append(" is not a subtype of Number?, only primitive numbers are supported in ");
            Aggregator<Number, Return> aggregator = this.getAggregator();
            Intrinsics.checkNotNull(aggregator);
            String $i$a$-require-NumberInputHandler$preprocessAggregation$32 = stringBuilder.append(aggregator.getName()).append('.').toString();
            throw new IllegalArgumentException($i$a$-require-NumberInputHandler$preprocessAggregation$32.toString());
        }
        KType kType = KTypes.withNullability((KType)valueType.getKType(), (boolean)false);
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
            KType unifiedType = this.calculateValueType(values).getKType();
            if (!(!NumberTypeUtilsKt.isMixedNumber(unifiedType))) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Types ").append(CollectionsKt.toSet((Iterable)TypeUtilsKt.types(SequencesKt.asIterable(values)))).append(" are not all primitive numbers, only those are supported in ");
                Aggregator<Number, Return> aggregator = this.getAggregator();
                Intrinsics.checkNotNull(aggregator);
                String string = stringBuilder.append(aggregator.getName()).append('.').toString();
                throw new IllegalArgumentException(string.toString());
            }
            Sequence<Number> unifiedValues = NumberTypeUtilsKt.convertNullableSequenceToUnifiedNumberType(values, UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY(), unifiedType);
            pair = new Pair(unifiedValues, (Object)unifiedType);
        } else if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType())) {
            pair = new Pair(values, (Object)valueType.getKType());
        } else {
            if (!NumberTypeUtilsKt.getPrimitiveNumberTypes().contains(kType)) {
                StringBuilder stringBuilder = new StringBuilder().append("Cannot calculate ");
                Aggregator<Number, Return> aggregator = this.getAggregator();
                Intrinsics.checkNotNull(aggregator);
                throw new IllegalArgumentException(stringBuilder.append(aggregator.getName()).append(" of ").append(RenderingKt.renderType(valueType.getKType())).append(", only primitive numbers are supported in statistics.").toString());
            }
            Sequence<? extends Number> unifiedValues = valueType.getNeedsFullConversion() ? NumberTypeUtilsKt.convertNullableSequenceToUnifiedNumberType(values, UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY(), valueType.getKType()) : values;
            pair = new Pair(unifiedValues, (Object)valueType.getKType());
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ValueType calculateValueType(@NotNull Set<? extends KType> valueTypes) {
        KType unifiedType;
        Intrinsics.checkNotNullParameter(valueTypes, (String)"valueTypes");
        KType kType = NumberTypeUtilsKt.unifiedNumberTypeOrNull((Iterable<? extends KType>)valueTypes, UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY());
        if (kType == null) {
            boolean bl;
            KType kType2;
            block5: {
                void $this$any$iv;
                Iterable iterable = valueTypes;
                kType2 = Reflection.typeOf(Number.class);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KType it = (KType)element$iv;
                        boolean bl2 = false;
                        if (!it.isMarkedNullable()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            kType = KTypes.withNullability((KType)kType2, (boolean)bl3);
        }
        if (!NumberTypeUtilsKt.isPrimitiveOrMixedNumber(unifiedType = kType) && !TypeUtilsKt.isNothing(unifiedType)) {
            StringBuilder stringBuilder = new StringBuilder().append("Cannot calculate ");
            Aggregator<Number, Return> aggregator = this.getAggregator();
            Intrinsics.checkNotNull(aggregator);
            throw new IllegalArgumentException(stringBuilder.append(aggregator.getName()).append(" of ").append(RenderingKt.renderType(unifiedType)).append(", only primitive numbers are supported.").toString());
        }
        return ValueTypeKt.toValueType(unifiedType, !Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((Iterable)valueTypes), (Object)unifiedType));
    }

    @Override
    @NotNull
    public ValueType calculateValueType(@NotNull Sequence<? extends Number> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.calculateValueType(CollectionsKt.toSet((Iterable)TypeUtilsKt.types(SequencesKt.asIterable(values))));
    }

    @Override
    @Nullable
    public Aggregator<Number, Return> getAggregator() {
        return this.aggregator;
    }

    @Override
    public void setAggregator(@Nullable Aggregator<? super Number, ? extends Return> aggregator) {
        this.aggregator = aggregator;
    }
}

