/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.performanceTesting;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.GradleCompatibilityState;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0094@\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0003H\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/performanceTesting/ValidateGradleMatrixCompatibilityCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.gradle.java"})
public final class ValidateGradleMatrixCompatibilityCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "validateGradleMatrixCompatibility";
    @NotNull
    public static final String PREFIX = "%validateGradleMatrixCompatibility";

    public ValidateGradleMatrixCompatibilityCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        String url = Registry.Companion.stringValue("gradle.compatibility.config.url");
        long expectedUpdateTime = System.currentTimeMillis() - Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)Registry.Companion.intValue("gradle.compatibility.update.interval"), (DurationUnit)DurationUnit.SECONDS));
        String string = HttpRequests.request((String)url).productNameAsUserAgent().readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String json = string;
        String string2 = ApplicationInfo.getInstance().getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullVersion(...)");
        IdeVersionedDataState ideVersionedDataState = GradleCompatibilityDataParser.INSTANCE.parseVersionedJson(json, string2);
        Intrinsics.checkNotNull((Object)ideVersionedDataState);
        GradleCompatibilityState expected = (GradleCompatibilityState)ideVersionedDataState;
        IdeVersionedDataState ideVersionedDataState2 = GradleJvmSupportMatrix.Companion.getInstance().getState();
        Intrinsics.checkNotNull((Object)ideVersionedDataState2);
        GradleCompatibilityState actual = (GradleCompatibilityState)ideVersionedDataState2;
        if (!actual.getSupportedGradleVersions().containsAll(expected.getSupportedGradleVersions())) {
            throw new IllegalStateException("Supported gradle versions Expected: " + expected.getSupportedGradleVersions() + " but " + actual.getSupportedGradleVersions() + " ");
        }
        if (!actual.getSupportedJavaVersions().containsAll(expected.getSupportedJavaVersions())) {
            throw new IllegalStateException("Supported java versions Expected: " + expected.getSupportedJavaVersions() + " but " + actual.getSupportedJavaVersions() + " ");
        }
        if (!actual.getCompatibility().containsAll(expected.getCompatibility())) {
            throw new IllegalStateException("Compatibility Expected: " + expected.getCompatibility() + " but " + actual.getCompatibility() + " ");
        }
        if (actual.getLastUpdateTime() < expectedUpdateTime) {
            throw new IllegalStateException("Last update time less then expected");
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/performanceTesting/ValidateGradleMatrixCompatibilityCommand$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

