/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.eclipse.sisu.inject.Logs;

final class BeanLifecycle
implements PrivilegedAction<Void> {
    private static final Method[] NO_METHODS = new Method[0];
    static final BeanLifecycle NO_OP = new BeanLifecycle(null, null);
    private final Method[] startMethods;
    private final Method[] stopMethods;

    BeanLifecycle(List<Method> startMethods, List<Method> stopMethods) {
        this.startMethods = BeanLifecycle.toArray(startMethods);
        this.stopMethods = BeanLifecycle.toArray(stopMethods);
        AccessController.doPrivileged(this);
    }

    public boolean isStartable() {
        return this.startMethods.length > 0;
    }

    public boolean isStoppable() {
        return this.stopMethods.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Object bean) {
        int i;
        Logs.trace("PostConstruct: <>", bean, null);
        try {
            for (i = this.startMethods.length - 1; i >= 0; --i) {
                this.startMethods[i].invoke(bean, new Object[0]);
            }
        }
        catch (Throwable e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            Logs.catchThrowable(cause);
            try {
                Logs.warn("Error starting: {}", this.startMethods[i], cause);
            }
            finally {
                Logs.throwUnchecked(cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Object bean) {
        Logs.trace("PreDestroy: <>", bean, null);
        for (int i = 0; i < this.stopMethods.length; ++i) {
            try {
                this.stopMethods[i].invoke(bean, new Object[0]);
                continue;
            }
            catch (Throwable e) {
                Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                Logs.catchThrowable(cause);
                try {
                    Logs.warn("Problem stopping: {}", this.stopMethods[i], cause);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Void run() {
        AccessibleObject.setAccessible(this.startMethods, true);
        AccessibleObject.setAccessible(this.stopMethods, true);
        return null;
    }

    private static Method[] toArray(List<Method> methods2) {
        return null != methods2 && !methods2.isEmpty() ? methods2.toArray(new Method[methods2.size()]) : NO_METHODS;
    }
}

