/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.freeplane.features.map.MapController;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.FoldingMark;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;

abstract class MainViewPainter {
    private static final Rectangle EMPTY_RECTANGLE = new Rectangle();
    MainView mainView;

    MainViewPainter(MainView mainView) {
        this.mainView = mainView;
    }

    int getMainViewHeightWithFoldingMark(boolean onlyFolded) {
        int height = this.mainView.getHeight();
        NodeView nodeView = this.mainView.getNodeView();
        if (nodeView.usesHorizontalLayout() && (!onlyFolded || nodeView.isFolded())) {
            height += 2 * this.mainView.getZoomedFoldingMarkHalfSize();
        }
        return height;
    }

    int getSingleChildShift() {
        return 0;
    }

    Point getConnectorPoint(Point relativeLocation, MainView.ConnectorLocation connectorLocation) {
        return connectorLocation.pointSupplier.apply(this);
    }

    Point getCenterPoint() {
        return new Point(this.mainView.getWidth() / 2, this.mainView.getHeight() / 2);
    }

    abstract Point getLeftPoint();

    abstract Point getRightPoint();

    Point getTopPoint() {
        return new Point(this.mainView.getWidth() / 2, 0);
    }

    Point getBottomPoint() {
        return new Point(this.mainView.getWidth() / 2, this.mainView.getHeight());
    }

    abstract NodeGeometryModel getShapeConfiguration();

    abstract void paintBackground(Graphics2D var1, Color var2);

    void paintComponent(Graphics graphics) {
        this.mainView.paintComponentDefault(graphics);
    }

    void paintDecoration(NodeView nodeView, Graphics2D g) {
        boolean shouldPaintCloneMarker;
        this.mainView.drawModificationRect(g);
        this.mainView.paintDragRectangle(g);
        this.paintFoldingMark(nodeView, g);
        boolean isMinimized = this.mainView.isShortened();
        boolean bl = shouldPaintCloneMarker = nodeView.getNode().isCloneNode() && this.mainView.shouldPaintCloneMarker(nodeView);
        if (isMinimized) {
            FoldingMark.SHORTENED.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, shouldPaintCloneMarker ? 0.6 : 0.0, 2.3333333333333335, 1.6666666666666667));
        }
        if (shouldPaintCloneMarker) {
            if (nodeView.getNode().isCloneTreeRoot()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 2.0, 2.5));
            } else if (nodeView.getNode().isCloneTreeNode()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 1.5, 2.5));
            } else if (nodeView.getNode().isCloneContentNodeOutsideCloneTree()) {
                FoldingMark.CLONE.draw(g, nodeView, this.mainView.decorationMarkBounds(nodeView, isMinimized ? -0.6 : 0.0, 2.4, 1.8));
            }
        }
    }

    void paintFoldingMark(NodeView nodeView, Graphics2D g) {
        boolean drawsControls;
        if (!this.mainView.hasChildren()) {
            return;
        }
        MapView map = this.mainView.getMap();
        MapController mapController = map.getModeController().getMapController();
        FoldingMark markType = this.mainView.foldingMarkType(mapController, nodeView);
        boolean bl = drawsControls = this.mainView.getMouseArea() != MouseArea.OUT && !map.isPrinting();
        if (markType == FoldingMark.FOLDING_CIRCLE_UNFOLDED && !drawsControls) {
            return;
        }
        Rectangle markBounds = this.getFoldingRectangleBounds(nodeView, drawsControls);
        (drawsControls || markType != FoldingMark.FOLDING_CIRCLE_FOLDED ? markType : FoldingMark.FOLDING_CIRCLE_UNFOLDED).draw(g, nodeView, markBounds);
    }

    Rectangle getFoldingRectangleBounds(NodeView nodeView, boolean drawsControls) {
        Point p;
        int halfWidth;
        int size = drawsControls ? Math.max(this.mainView.getZoomedFoldingSwitchMinWidth(), this.mainView.getZoomedFoldingMarkHalfSize() * 2) : this.mainView.getZoomedFoldingMarkHalfSize() * 2;
        int halfHeight = size / 2;
        MapView map = nodeView.getMap();
        int n = halfWidth = drawsControls ? halfHeight : Math.min(map.getZoomed(NodeView.MAXIMUM_FOLDING_MARK_HALF_WIDTH_FOR_COMPACTED_MAPS), halfHeight);
        if (!drawsControls && !nodeView.isFolded()) {
            return EMPTY_RECTANGLE;
        }
        if (nodeView.usesHorizontalLayout()) {
            if (nodeView.isTopOrLeft()) {
                p = this.getTopPoint();
                p.y -= halfHeight;
            } else {
                p = this.getBottomPoint();
                p.y += halfHeight;
            }
        } else {
            Point point = p = this.mainView.getNodeView().paintsChildrenOnTheLeft() ? this.getLeftPoint() : this.getRightPoint();
            p.x = p.x <= 0 ? (p.x -= halfWidth) : (p.x += halfWidth);
        }
        Rectangle markBounds = new Rectangle(p.x - halfWidth, p.y - halfHeight, halfWidth * 2, halfHeight * 2);
        return markBounds;
    }

    boolean areInsetsFixed() {
        return true;
    }

    Insets getZoomedInsets() {
        return this.mainView.getDefaultZoomedInsets();
    }

    Insets getInsets() {
        return this.mainView.getDefaultInsets();
    }

    Insets getInsets(Insets insets) {
        return this.mainView.getDefaultInsets(insets);
    }

    Dimension getPreferredSize() {
        return this.mainView.getDefaultPreferredSize();
    }

    void setBounds(int x, int y, int width, int height) {
        this.mainView.setBoundsDefault(x, y, width, height);
    }
}

