/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opensearch.Version;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.neuralsearch.query.NeuralQueryBuilder;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;

public final class MinClusterVersionUtil {
    private static final Version MINIMAL_SUPPORTED_VERSION_DEFAULT_DENSE_MODEL_ID = Version.V_2_11_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH = Version.V_2_14_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_QUERY_IMAGE_FIX = Version.V_2_19_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_PAGINATION_IN_HYBRID_QUERY = Version.V_2_19_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_NEURAL_ORIGINAL_QUERY_TEXT = Version.V_3_0_0;
    public static final Version MINIMAL_SUPPORTED_VERSION_SEMANTIC_FIELD = Version.V_3_1_0;
    public static final Version MINIMAL_SUPPORTED_VERSION_SEMANTIC_FIELD_SPARSE_TWO_PHASE = Version.V_3_3_0;
    public static final Version MINIMAL_SUPPORTED_VERSION_STATS_CATEGORY_FILTERING = Version.V_3_1_0;
    public static final Version MINIMAL_SUPPORTED_VERSION_METRICS_STATS = Version.V_3_3_0;
    private static final Version MINIMAL_SUPPORTED_VERSION_NEURAL_KNN_QUERY_BUILDER = Version.V_3_0_0;
    public static final String NEURAL_KNN_QUERY = "neural_knn_query";
    private static final Map<String, Version> MINIMAL_VERSION_NEURAL = ImmutableMap.builder().put((Object)NeuralQueryBuilder.MODEL_ID_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_DEFAULT_DENSE_MODEL_ID).put((Object)KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH).put((Object)KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH).put((Object)NeuralQueryBuilder.QUERY_IMAGE_FIELD.getPreferredName(), (Object)MINIMAL_SUPPORTED_VERSION_QUERY_IMAGE_FIX).put((Object)"neural_knn_query", (Object)MINIMAL_SUPPORTED_VERSION_NEURAL_KNN_QUERY_BUILDER).build();

    public static boolean isClusterOnOrAfterMinReqVersionForDefaultDenseModelIdSupport() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_DEFAULT_DENSE_MODEL_ID);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForRadialSearch() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_RADIAL_SEARCH);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForPaginationInHybridQuery() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_PAGINATION_IN_HYBRID_QUERY);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForStatCategoryFiltering() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_STATS_CATEGORY_FILTERING);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForMetricStats() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_METRICS_STATS);
    }

    public static boolean isClusterOnOrAfterMinReqVersion(String key) {
        Version version = MINIMAL_VERSION_NEURAL.containsKey(key) ? MINIMAL_VERSION_NEURAL.get(key) : (Version)IndexUtil.minimalRequiredVersionMap.get(key);
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(version);
    }

    public static boolean isVersionOnOrAfterMinReqVersionForNeuralKNNQueryText(Version version) {
        return version.onOrAfter(MINIMAL_SUPPORTED_VERSION_NEURAL_ORIGINAL_QUERY_TEXT);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForSemanticFieldType() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_SEMANTIC_FIELD);
    }

    public static boolean isClusterOnOrAfterMinReqVersionForNeuralKNNQueryBuilder() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_NEURAL_KNN_QUERY_BUILDER);
    }
}

