"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSuperUpdateButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button = require("../../button");
var _i18n = require("../../i18n");
var _tool_tip = require("../../tool_tip");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiSuperUpdateButton = /*#__PURE__*/function (_Component) {
  _inherits(EuiSuperUpdateButton, _Component);
  var _super = _createSuper(EuiSuperUpdateButton);
  function EuiSuperUpdateButton() {
    var _this;
    _classCallCheck(this, EuiSuperUpdateButton);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);
    _defineProperty(_assertThisInitialized(_this), "tooltipTimeout", void 0);
    _defineProperty(_assertThisInitialized(_this), "tooltip", null);
    _defineProperty(_assertThisInitialized(_this), "setTootipRef", function (node) {
      _this.tooltip = node;
    });
    _defineProperty(_assertThisInitialized(_this), "showTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.showToolTip();
    });
    _defineProperty(_assertThisInitialized(_this), "hideTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.hideToolTip();
    });
    return _this;
  }
  _createClass(EuiSuperUpdateButton, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;
      if (this.props.showTooltip && this.props.needsUpdate && !this.props.isDisabled && !this.props.isLoading) {
        this.showTooltip();
        this.tooltipTimeout = setTimeout(function () {
          _this2.hideTooltip();
        }, 2000);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        className = _this$props.className,
        needsUpdate = _this$props.needsUpdate,
        isLoading = _this$props.isLoading,
        isDisabled = _this$props.isDisabled,
        onClick = _this$props.onClick,
        toolTipProps = _this$props.toolTipProps,
        showTooltip = _this$props.showTooltip,
        compressed = _this$props.compressed,
        restTextProps = _this$props.textProps,
        rest = _objectWithoutProperties(_this$props, ["className", "needsUpdate", "isLoading", "isDisabled", "onClick", "toolTipProps", "showTooltip", "compressed", "textProps"]);
      var classes = (0, _classnames.default)('euiSuperUpdateButton', className);
      var buttonText = /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiSuperUpdateButton.refreshButtonLabel",
        default: "Refresh"
      });
      if (needsUpdate || isLoading) {
        buttonText = isLoading ? /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.updatingButtonLabel",
          default: "Updating"
        }) : /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.updateButtonLabel",
          default: "Update"
        });
      }
      var tooltipContent;
      if (isDisabled) {
        tooltipContent = /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.cannotUpdateTooltip",
          default: "Cannot update"
        });
      } else if (needsUpdate && !isLoading) {
        tooltipContent = /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          token: "euiSuperUpdateButton.clickToApplyTooltip",
          default: "Click to apply"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_tool_tip.EuiToolTip, _extends({
        ref: this.setTootipRef,
        content: tooltipContent,
        position: "bottom"
      }, toolTipProps), /*#__PURE__*/_react.default.createElement(_button.EuiButton, _extends({
        className: classes,
        color: needsUpdate || isLoading ? 'success' : 'primary',
        iconType: "refresh",
        textProps: _objectSpread(_objectSpread({}, restTextProps), {}, {
          className: (0, _classnames.default)('euiSuperUpdateButton__text', restTextProps === null || restTextProps === void 0 ? void 0 : restTextProps.className)
        }),
        isDisabled: isDisabled,
        onClick: onClick,
        isLoading: isLoading,
        size: compressed ? 's' : 'm'
      }, rest), buttonText));
    }
  }]);
  return EuiSuperUpdateButton;
}(_react.Component);
exports.EuiSuperUpdateButton = EuiSuperUpdateButton;
_defineProperty(EuiSuperUpdateButton, "defaultProps", {
  needsUpdate: false,
  isLoading: false,
  isDisabled: false,
  showTooltip: false,
  compressed: false
});
EuiSuperUpdateButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  isDisabled: _propTypes.default.bool.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  needsUpdate: _propTypes.default.bool.isRequired,
  onClick: _propTypes.default.func.isRequired,
  /**
       * Passes props to `EuiToolTip`
       */
  toolTipProps: _propTypes.default.shape({
    /**
       * Passes onto the the trigger.
       */
    anchorClassName: _propTypes.default.string,
    /**
       * The in-view trigger for your tooltip.
       */
    children: _propTypes.default.element.isRequired,
    /**
       * Passes onto the tooltip itself, not the trigger.
       */
    className: _propTypes.default.string,
    /**
       * The main content of your tooltip.
       */
    content: _propTypes.default.node,
    /**
       * Common display alternatives for the anchor wrapper
       */
    display: _propTypes.default.oneOf(["inlineBlock", "block"]),
    /**
       * Delay before showing tooltip. Good for repeatable items.
       */
    delay: _propTypes.default.oneOf(["regular", "long"]).isRequired,
    /**
       * An optional title for your tooltip.
       */
    title: _propTypes.default.node,
    /**
       * Unless you provide one, this will be randomly generated.
       */
    id: _propTypes.default.string,
    /**
       * Suggested position. If there is not enough room for it this will be changed.
       */
    position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired,
    /**
       * If supplied, called when mouse movement causes the tool tip to be
       * hidden.
       */
    onMouseOut: _propTypes.default.func
  }),
  /**
       * Show the "Click to apply" tooltip
       */
  showTooltip: _propTypes.default.bool.isRequired,
  compressed: _propTypes.default.bool
};