/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.database.liquibase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.exception.ServiceNotFoundException;
import liquibase.servicelocator.StandardServiceLocator;

public class FastServiceLocator
extends StandardServiceLocator {
    private Map<String, List<String>> services = new HashMap<String, List<String>>();

    public int getPriority() {
        return super.getPriority() + 1;
    }

    public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
        List<String> found = this.services.get(interfaceType.getName());
        if (found == null) {
            return super.findInstances(interfaceType);
        }
        ArrayList ret = new ArrayList();
        for (String i : found) {
            try {
                ret.add(Class.forName(i, false, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to find Liquibase implementation", e);
            }
        }
        return ret;
    }

    public void initServices(Map<String, List<String>> services) {
        this.services = services;
    }
}

