/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import io.agroal.narayana.XAExceptionUtils;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.tm.LastResource;
import org.jboss.tm.XAResourceWrapper;

public class LocalXAResource
implements XAResourceWrapper,
LastResource {
    private static final String PRODUCT_NAME = LocalXAResource.class.getPackage().getImplementationTitle();
    private static final String PRODUCT_VERSION = LocalXAResource.class.getPackage().getImplementationVersion();
    private final TransactionAware transactionAware;
    private final String jndiName;
    private Xid currentXid;

    public LocalXAResource(TransactionAware transactionAware, String jndiName) {
        this.transactionAware = transactionAware;
        this.jndiName = jndiName;
    }

    public Object getConnection() throws Throwable {
        return this.transactionAware.getConnection();
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.currentXid == null) {
            if (flags != 0) {
                throw XAExceptionUtils.xaException(-5, "Starting resource with wrong flags");
            }
            try {
                this.transactionAware.transactionStart();
            }
            catch (Exception t) {
                this.transactionAware.setFlushOnly();
                throw XAExceptionUtils.xaException(-3, "Error trying to start local transaction: ", t);
            }
            this.currentXid = xid;
        } else if (flags != 0x200000 && flags != 0x8000000) {
            throw XAExceptionUtils.xaException(-8, "Invalid flag for join|resume");
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw XAExceptionUtils.xaException(-4, "Invalid xid to transactionCommit");
        }
        this.currentXid = null;
        try {
            this.transactionAware.transactionBeforeCompletion(true);
            this.transactionAware.transactionCommit();
        }
        catch (Exception t) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtils.xaException(onePhase ? 100 : -3, "Error trying to transactionCommit local transaction: ", t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            throw XAExceptionUtils.xaException(-4, "Invalid xid to transactionRollback");
        }
        this.currentXid = null;
        try {
            this.transactionAware.transactionBeforeCompletion(false);
            this.transactionAware.transactionRollback();
        }
        catch (Exception t) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtils.xaException(-3, "Error trying to transactionRollback local transaction: ", t);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (xid == null || !xid.equals(this.currentXid)) {
            this.transactionAware.setFlushOnly();
            throw XAExceptionUtils.xaException(-4, "Invalid xid to transactionEnd");
        }
    }

    public void forget(Xid xid) throws XAException {
        this.transactionAware.setFlushOnly();
        throw XAExceptionUtils.xaException(-4, "Forget not supported in local XA resource");
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return this == xaResource;
    }

    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    public Xid[] recover(int flags) throws XAException {
        this.transactionAware.setFlushOnly();
        throw XAExceptionUtils.xaException(-3, "No recover in local XA resource");
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        return false;
    }

    public XAResource getResource() {
        return this;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    public String getJndiName() {
        return this.jndiName;
    }
}

