/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapecgo;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapecgo.CGOMesh;

public class CGO
extends MeshCollection {
    CGOMesh[] cmeshes = new CGOMesh[4];
    private CGOMesh cgoMesh;
    private boolean useColix;
    private float newScale;
    private int indicatedModelIndex = Integer.MIN_VALUE;

    public CGO() {
        this.myType = "CGO";
        this.htObjects = new Hashtable();
    }

    private void initCGO() {
        this.indicatedModelIndex = Integer.MIN_VALUE;
    }

    @Override
    public void allocMesh(String thisID, Mesh m) {
        int index = this.meshCount++;
        this.cmeshes = (CGOMesh[])AU.ensureLength(this.cmeshes, this.meshCount * 2);
        this.meshes = this.cmeshes;
        this.cmeshes[index] = m == null ? new CGOMesh(this.vwr, thisID, this.colix, index) : (CGOMesh)m;
        this.cgoMesh = this.cmeshes[index];
        this.currentMesh = this.cmeshes[index];
        this.currentMesh.color = this.color;
        this.currentMesh.index = index;
        this.currentMesh.useColix = this.useColix;
        this.currentMesh.modelIndex = this.indicatedModelIndex;
        if (thisID != null && thisID != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(thisID.toUpperCase(), this.currentMesh);
        }
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("init" == propertyName) {
            this.initCGO();
            this.setPropertySuper("init", value, bs);
            return;
        }
        if ("setCGO" == propertyName) {
            Map map = (Map)value;
            Lst list = (Lst)map.get("info");
            this.setProperty("init", null, null);
            int n = list.size() - 1;
            this.setProperty("thisID", list.get(n), null);
            propertyName = "set";
            this.setProperty("set", list, null);
            this.cgoMesh.meshWidth = ((Double)map.get("mesh_width")).floatValue();
            return;
        }
        if ("modelIndex" == propertyName) {
            this.indicatedModelIndex = Math.max((Integer)value, -1);
            return;
        }
        if ("set" == propertyName) {
            if (this.cgoMesh == null) {
                this.allocMesh(null, null);
                this.cgoMesh.colix = this.colix;
                this.cgoMesh.color = this.color;
                this.cgoMesh.useColix = this.useColix;
            }
            this.cgoMesh.modelIndex = this.indicatedModelIndex == Integer.MIN_VALUE ? this.vwr.am.cmi : this.indicatedModelIndex;
            this.cgoMesh.isValid = this.setCGO((Lst)value);
            if (this.cgoMesh.isValid) {
                this.scale(this.cgoMesh, this.newScale);
                this.cgoMesh.initialize(1073741964, null, null);
                this.cgoMesh.title = this.title;
                this.cgoMesh.visible = true;
            }
            this.clean();
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])value)[2])[0]);
            return;
        }
        this.setPropertySuper(propertyName, value, bs);
    }

    protected void deleteModels(int modelIndex) {
        int i = this.meshCount;
        while (--i >= 0) {
            boolean deleteMesh;
            CGOMesh m = (CGOMesh)this.meshes[i];
            if (m == null) continue;
            boolean bl = deleteMesh = m.modelIndex == modelIndex;
            if (deleteMesh) {
                --this.meshCount;
                this.deleteMeshElement(i);
                continue;
            }
            if (this.meshes[i].modelIndex <= modelIndex) continue;
            --this.meshes[i].modelIndex;
        }
        this.resetObjects();
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property == "command") {
            return this.getCommand(this.cgoMesh);
        }
        return this.getPropMC(property, index);
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        if (property == "data") {
            return CGOMesh.getData(data);
        }
        return this.getPropDataMC(property, data);
    }

    private void deleteMeshElement(int i) {
        if (this.meshes[i] == this.currentMesh) {
            this.cgoMesh = null;
            this.currentMesh = null;
        }
        this.cmeshes = (CGOMesh[])AU.deleteElements(this.meshes, i, 1);
        this.meshes = this.cmeshes;
    }

    private void setPropertySuper(String propertyName, Object value, BS bs) {
        this.currentMesh = this.cgoMesh;
        this.setPropMC(propertyName, value, bs);
        this.cgoMesh = (CGOMesh)this.currentMesh;
    }

    @Override
    protected void clean() {
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i] != null && this.cmeshes[i].cmds != null && this.cmeshes[i].cmds.size() != 0) continue;
            this.deleteMeshI(i);
        }
    }

    private boolean setCGO(Lst<Object> data) {
        if (this.cgoMesh == null) {
            this.allocMesh(null, null);
        }
        this.cgoMesh.clear("cgo");
        return this.cgoMesh.set(data);
    }

    private void scale(Mesh mesh, float newScale) {
    }

    @Override
    public Object getShapeDetail() {
        Lst V = new Lst();
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh mesh = this.cmeshes[i];
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("visible", mesh.visible ? Boolean.TRUE : Boolean.FALSE);
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("command", this.getCommand(mesh));
            V.addLast(info);
        }
        return V;
    }

    @Override
    public String getShapeState() {
        SB sb = new SB();
        int modelCount = this.ms.mc;
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh mesh = this.cmeshes[i];
            if (mesh == null || mesh.cmds == null || mesh.modelIndex >= modelCount) continue;
            if (sb.length() == 0) {
                sb.append("\n");
                CGO.appendCmd(sb, this.myType + " delete");
            }
            sb.append(this.getCommand2(mesh, modelCount));
            if (mesh.visible) continue;
            sb.append(" " + this.myType + " ID " + PT.esc(mesh.thisID) + " off;\n");
        }
        return sb.toString();
    }

    private String getCommand(Mesh mesh) {
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sb = new SB();
        String key = this.explicitID && this.previousMeshID != null && PT.isWild(this.previousMeshID) ? this.previousMeshID : null;
        Lst<Mesh> list = this.getMeshList(key, false);
        int i = list.size();
        while (--i >= 0) {
            Mesh m = (Mesh)list.get(i);
            sb.append(this.getCommand2(m, m.modelIndex));
        }
        return sb.toString();
    }

    private String getCommand2(Mesh mesh, int modelCount) {
        CGOMesh cmesh = (CGOMesh)mesh;
        SB str = new SB();
        int iModel = mesh.modelIndex;
        str.append("  CGO ID ").append(PT.esc(mesh.thisID));
        if (iModel >= -1 && modelCount > 1) {
            str.append(" modelIndex " + iModel);
        }
        str.append(" [");
        int n = cmesh.cmds.size();
        for (int i = 0; i < n; ++i) {
            str.append(" " + cmesh.cmds.get(i));
        }
        str.append(" ];\n");
        CGO.appendCmd(str, cmesh.getState("cgo"));
        if (cmesh.useColix) {
            CGO.appendCmd(str, CGO.getColorCommandUnk("cgo", cmesh.colix, this.translucentAllowed));
        }
        return str.toString();
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        for (int i = 0; i < this.meshCount; ++i) {
            CGOMesh m = this.cmeshes[i];
            if (m == null) continue;
            m.setVisibilityFlags(m.isValid && m.visible && (m.modelIndex < 0 || bsModels.get(m.modelIndex)) ? this.vf : 0);
        }
    }
}

