/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;

public abstract class BondCollection
extends AtomCollection {
    public Bond[] bo;
    public int bondCount;
    protected int[] numCached;
    protected Bond[][][] freeBonds;
    protected JmolMolecule[] molecules;
    protected int moleculeCount;
    protected short defaultCovalentMad;
    private BS bsAromaticSingle;
    private BS bsAromaticDouble;
    protected BS bsAromatic;
    public boolean haveHiddenBonds;
    protected V3 v1 = new V3();
    protected V3 v2 = new V3();
    protected static final int BOND_GROWTH_INCREMENT = 250;
    protected static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    protected static final int MAX_NUM_TO_CACHE = 200;
    protected boolean haveAtropicBonds;

    protected void setupBC() {
        this.bsAromatic = new BS();
        this.numCached = new int[5];
        this.freeBonds = new Bond[5][][];
        int i = 5;
        while (--i > 0) {
            this.freeBonds[i] = new Bond[200][];
        }
        this.setupAC();
    }

    protected void releaseModelSetBC() {
        this.bo = null;
        this.freeBonds = null;
        this.releaseModelSetAC();
    }

    public BondIterator getBondIteratorForType(int bondType, BS bsAtoms) {
        return new BondIteratorSelected(this.bo, this.bondCount, bondType, bsAtoms, this.vwr.getBoolean(0x24000024));
    }

    public BondIterator getBondIterator(BS bsBonds) {
        return new BondIteratorSelected(this.bo, this.bondCount, 131071, bsBonds, false);
    }

    public short getBondColix1(int i) {
        return C.getColixInherited(this.bo[i].colix, this.bo[i].atom1.colixAtom);
    }

    public short getBondColix2(int i) {
        return C.getColixInherited(this.bo[i].colix, this.bo[i].atom2.colixAtom);
    }

    protected int getBondCountInModel(int modelIndex) {
        int n = 0;
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bo[i] == null || this.bo[i].atom1.mi != modelIndex) continue;
            ++n;
        }
        return n;
    }

    public BS getBondsForSelectedAtoms(BS bsAtoms, boolean bondSelectionModeOr) {
        BS bs = new BS();
        int n = bsAtoms.cardinality();
        switch (n) {
            case 0: {
                return bs;
            }
            case 1: 
            case 2: {
                Atom b;
                Atom a = this.at[bsAtoms.nextSetBit(0)];
                Atom atom = b = n == 2 ? this.at[bsAtoms.nextSetBit(a.i + 1)] : null;
                if (n == 1 || bondSelectionModeOr) {
                    int i = a.getBondCount();
                    while (--i >= 0) {
                        bs.set(a.bonds[i].index);
                    }
                    if (b != null) {
                        i = b.getBondCount();
                        while (--i >= 0) {
                            bs.set(b.bonds[i].index);
                        }
                    }
                } else {
                    Bond bond = a.getBond(b);
                    if (bond != null) {
                        bs.set(bond.index);
                    }
                }
                return bs;
            }
        }
        for (int iBond = 0; iBond < this.bondCount; ++iBond) {
            Bond bond = this.bo[iBond];
            if (bond == null) continue;
            boolean isSelected1 = bsAtoms.get(bond.atom1.i);
            boolean isSelected2 = bsAtoms.get(bond.atom2.i);
            if (!(bondSelectionModeOr ? isSelected1 || isSelected2 : isSelected1 && isSelected2)) continue;
            bs.set(iBond);
        }
        return bs;
    }

    public Bond bondAtoms(Atom atom1, Atom atom2, int order, short mad, BS bsBonds, float energy, boolean addGroup, boolean isNew) {
        Bond bond = this.getOrAddBond(atom1, atom2, order, mad, bsBonds, energy, true);
        if (isNew) {
            bond.order |= 0x20000;
            if (addGroup) {
                atom1.group = atom2.group;
                atom1.group.addAtoms(atom1.i);
            }
        }
        return bond;
    }

    protected Bond getOrAddBond(Atom atom, Atom atomOther, int order, short mad, BS bsBonds, float energy, boolean overrideBonding) {
        int i;
        if (order == 131071 || order == 65535) {
            order = 1;
        }
        if (atom.isBonded(atomOther)) {
            i = atom.getBond((Atom)atomOther).index;
            if (overrideBonding) {
                this.bo[i].setOrder(order);
                this.bo[i].setMad(mad);
                if (this.bo[i] instanceof HBond) {
                    ((HBond)this.bo[i]).energy = energy;
                }
            }
        } else {
            if (this.bondCount == this.bo.length) {
                this.bo = (Bond[])AU.arrayCopyObject(this.bo, this.bondCount + 250);
            }
            i = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atomOther, (int)order, (short)mad, (float)energy)).index;
        }
        if (bsBonds != null) {
            bsBonds.set(i);
        }
        return this.bo[i];
    }

    protected Bond setBond(int index, Bond bond) {
        bond.index = index;
        this.bo[bond.index] = bond;
        return this.bo[bond.index];
    }

    protected Bond bondMutually(Atom atom, Atom atomOther, int order, short mad, float energy) {
        Bond bond = Edge.isOrderH(order) ? new HBond(atom, atomOther, order, mad, 0, energy) : new Bond(atom, atomOther, order, mad, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atomOther, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond newBond, Bond[] oldBonds) {
        Bond[] newBonds;
        if (oldBonds == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                newBonds = this.freeBonds[1][this.numCached[1]];
            } else {
                newBonds = new Bond[]{newBond};
            }
        } else {
            int oldLength = oldBonds.length;
            int newLength = oldLength + 1;
            if (newLength < 5 && this.numCached[newLength] > 0) {
                int n = newLength;
                int n2 = this.numCached[n] - 1;
                this.numCached[n] = n2;
                newBonds = this.freeBonds[newLength][n2];
            } else {
                newBonds = new Bond[newLength];
            }
            newBonds[oldLength] = newBond;
            int i = oldLength;
            while (--i >= 0) {
                newBonds[i] = oldBonds[i];
            }
            if (oldLength < 5 && this.numCached[oldLength] < 200) {
                int n = oldLength;
                int n3 = this.numCached[n];
                this.numCached[n] = n3 + 1;
                this.freeBonds[oldLength][n3] = oldBonds;
            }
        }
        return newBonds;
    }

    public int addHBond(Atom atom1, Atom atom2, int order, float energy) {
        if (this.bondCount == this.bo.length) {
            this.bo = (Bond[])AU.arrayCopyObject(this.bo, this.bondCount + 250);
        }
        return this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom1, (Atom)atom2, (int)order, (short)1, (float)energy)).index;
    }

    protected void deleteAllBonds2() {
        this.vwr.setShapeProperty(1, "reset", null);
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bo[i] == null) continue;
            this.bo[i].deleteAtomReferences();
            this.bo[i] = null;
        }
        this.bondCount = 0;
    }

    public short getDefaultMadFromOrder(int order) {
        return (short)(Edge.isOrderH(order) ? 1 : (order == 32768 ? (int)Math.floor(this.vwr.getFloat(570425406) * 2000.0f) : this.defaultCovalentMad));
    }

    protected int[] deleteConnections(float minD, float maxD, int order, BS bsA, BS bsB, boolean isBonds, boolean matchNull) {
        int i;
        BS bsBonds;
        boolean minDIsFraction = minD < 0.0f;
        boolean maxDIsFraction = maxD < 0.0f;
        boolean isFractional = minDIsFraction || maxDIsFraction;
        minD = this.fixD(minD, minDIsFraction);
        maxD = this.fixD(maxD, maxDIsFraction);
        BS bsDelete = new BS();
        int nDeleted = 0;
        int newOrder = order |= 0x20000;
        if (!matchNull && Edge.isOrderH(order)) {
            order = 30720;
        }
        if (isBonds) {
            bsBonds = bsA;
        } else {
            bsBonds = new BS();
            i = bsA.nextSetBit(0);
            while (i >= 0) {
                Atom a = this.at[i];
                if (a.bonds != null) {
                    int j = a.bonds.length;
                    while (--j >= 0) {
                        if (!bsB.get(a.getBondedAtomIndex(j))) continue;
                        bsBonds.set(a.bonds[j].index);
                    }
                }
                i = bsA.nextSetBit(i + 1);
            }
        }
        i = bsBonds.nextSetBit(0);
        while (i < this.bondCount && i >= 0) {
            Bond bond = this.bo[i];
            if (bond != null && this.isInRange(bond.atom1, bond.atom2, minD, maxD, minDIsFraction, maxDIsFraction, isFractional) && (matchNull || newOrder == (bond.order & 0xFFFFFEFF | 0x20000) || (order & bond.order & 0x7800) != 0)) {
                bsDelete.set(i);
                ++nDeleted;
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        if (nDeleted > 0) {
            ((ModelSet)this).deleteBonds(bsDelete, false);
        }
        return new int[]{0, nDeleted};
    }

    protected float fixD(float d, boolean isF) {
        return isF ? -d : d * d;
    }

    protected boolean isInRange(Atom atom1, Atom atom2, float minD, float maxD, boolean minFrac, boolean maxfrac, boolean isFractional) {
        float d2 = atom1.distanceSquared(atom2);
        if (isFractional) {
            float dAB = (float)Math.sqrt(d2);
            float dABcalc = atom1.getBondingRadius() + atom2.getBondingRadius();
            return (minFrac ? dAB >= dABcalc * minD : d2 >= minD) && (maxfrac ? dAB <= dABcalc * maxD : d2 <= maxD);
        }
        return d2 >= minD && d2 <= maxD;
    }

    protected void dBb(BS bsBond, boolean isFullModel) {
        int n = bsBond.cardinality();
        if (n == 0) {
            return;
        }
        ((ModelSet)this).resetMolecules();
        short modelIndexLast = -1;
        int i = bsBond.nextSetBit(0);
        while (i >= 0 && i < this.bondCount) {
            Bond bond = this.bo[i];
            if (bond != null && bsBond.get(i)) {
                short modelIndex;
                if (!isFullModel && (modelIndex = bond.atom1.mi) != modelIndexLast) {
                    modelIndexLast = modelIndex;
                    ((ModelSet)this).am[modelIndexLast].resetBoundCount();
                }
                bond.deleteAtomReferences();
                this.bo[i] = null;
            }
            i = bsBond.nextSetBit(i + 1);
        }
        BS[] sets = (BS[])this.vwr.getShapeProperty(1, "sets");
        if (sets != null) {
            for (int i2 = 0; i2 < sets.length; ++i2) {
                if (sets[i2] == null) continue;
                sets[i2].andNot(bsBond);
            }
        }
        this.bsAromatic.andNot(bsBond);
    }

    public void resetAromatic() {
        int i = this.bondCount;
        while (--i >= 0) {
            Bond bond = this.bo[i];
            if (bond == null || !bond.isAromatic()) continue;
            bond.setOrder(515);
        }
    }

    public void assignAromaticBondsBs(boolean isUserCalculation, BS bsBonds) {
        int i0;
        if (!isUserCalculation) {
            this.bsAromatic = new BS();
        }
        this.bsAromaticSingle = new BS();
        this.bsAromaticDouble = new BS();
        boolean isAll = bsBonds == null;
        int i = i0 = isAll ? this.bondCount - 1 : bsBonds.nextSetBit(0);
        while (i >= 0) {
            Bond bond = this.bo[i];
            if (bond != null) {
                if (this.bsAromatic.get(i)) {
                    bond.setOrder(515);
                }
                switch (bond.order & 0x1FFFF) {
                    case 515: {
                        if (!this.assignAromaticMustBeSingle(bond.atom1) && !this.assignAromaticMustBeSingle(bond.atom2)) {
                            this.bsAromatic.set(i);
                            break;
                        }
                        bond.order = 513;
                    }
                    case 513: {
                        this.bsAromaticSingle.set(i);
                        break;
                    }
                    case 514: {
                        this.bsAromaticDouble.set(i);
                    }
                }
            }
            i = isAll ? i - 1 : bsBonds.nextSetBit(i + 1);
        }
        isAll = bsBonds == null;
        i0 = isAll ? this.bondCount - 1 : bsBonds.nextSetBit(0);
        BS bsTest = new BS();
        int i2 = i0;
        while (i2 >= 0) {
            Bond bond = this.bo[i2];
            if (bond != null && bond.is(515) && !this.bsAromaticDouble.get(i2) && !this.bsAromaticSingle.get(i2)) {
                bsTest.set(i2);
                if (!(bond.atom1.getElementNumber() != 8 && bond.atom2.getElementNumber() != 8 || this.assignAromaticDouble(bond))) {
                    this.assignAromaticSingle(bond);
                }
            }
            i2 = isAll ? i2 - 1 : bsBonds.nextSetBit(i2 + 1);
        }
        i2 = bsTest.nextSetBit(0);
        while (i2 >= 0) {
            Bond bond = this.bo[i2];
            if (!this.assignAromaticDouble(bond)) {
                this.assignAromaticSingle(bond);
            }
            i2 = bsTest.nextSetBit(i2 + 1);
        }
        BS bsModels = new BS();
        int i3 = i0;
        while (i3 >= 0) {
            Bond bond = this.bo[i3];
            if (bond != null) {
                if (this.bsAromaticDouble.get(i3)) {
                    if (!bond.is(514)) {
                        this.bsAromatic.set(i3);
                        bsModels.set(bond.atom1.mi);
                        bond.setOrder(this.isLinear(bond, this.v1, this.v2) ? 3 : 514);
                    }
                } else if ((this.bsAromaticSingle.get(i3) || bond.isAromatic()) && !bond.is(513)) {
                    this.bsAromatic.set(i3);
                    bond.setOrder(513);
                }
            }
            i3 = isAll ? i3 - 1 : bsBonds.nextSetBit(i3 + 1);
        }
        Model[] models = ((ModelSet)this).am;
        int i4 = bsModels.nextSetBit(0);
        while (i4 >= 0) {
            if (models[i4].isBioModel) {
                models[i4].isPdbWithMultipleBonds = true;
            }
            i4 = bsModels.nextSetBit(i4 + 1);
        }
        this.assignAromaticNandO(bsBonds);
        this.bsAromaticSingle = null;
        this.bsAromaticDouble = null;
    }

    private boolean isLinear(Bond b, V3 v1, V3 v2) {
        if (b.order == 3) {
            return true;
        }
        if (b.atom1.getCovalentBondCount() != 2 || b.atom2.getCovalentBondCount() != 2) {
            return false;
        }
        Edge[] edges = b.atom1.getEdges();
        int i = edges.length;
        while (-i >= 0) {
            if (edges[i] == b || !edges[i].isCovalent()) continue;
            if (!(Measure.computeAngle((Atom)edges[i].getOtherNode(b.atom1), b.atom1, b.atom2, v1, v2, true) < 175.0f)) break;
            return false;
        }
        edges = b.atom2.getEdges();
        i = edges.length;
        while (-i >= 0) {
            if (edges[i] == b || !edges[i].isCovalent()) continue;
            if (!(Measure.computeAngle((Atom)edges[i].getOtherNode(b.atom2), b.atom2, b.atom1, v1, v2, true) < 175.0f)) break;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDouble(Bond bond) {
        int bondIndex = bond.index;
        if (this.bsAromaticSingle.get(bondIndex)) {
            return false;
        }
        if (this.bsAromaticDouble.get(bondIndex)) {
            return true;
        }
        this.bsAromaticDouble.set(bondIndex);
        if (!this.assignAromaticSingleForAtom(bond.atom1, bondIndex) || !this.assignAromaticSingleForAtom(bond.atom2, bondIndex)) {
            this.bsAromaticDouble.clear(bondIndex);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingle(Bond bond) {
        int bondIndex = bond.index;
        if (this.bsAromaticDouble.get(bondIndex)) {
            return false;
        }
        if (this.bsAromaticSingle.get(bondIndex)) {
            return true;
        }
        this.bsAromaticSingle.set(bondIndex);
        if (!this.assignAromaticDoubleForAtom(bond.atom1) || !this.assignAromaticDoubleForAtom(bond.atom2)) {
            this.bsAromaticSingle.clear(bondIndex);
            return false;
        }
        return true;
    }

    private boolean assignAromaticSingleForAtom(Atom atom, int notBondIndex) {
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return false;
        }
        int i = bonds.length;
        while (--i >= 0) {
            Bond bond = bonds[i];
            int bondIndex = bond.index;
            if (bondIndex == notBondIndex || !bond.isAromatic() || this.bsAromaticSingle.get(bondIndex) || !this.bsAromaticDouble.get(bondIndex) && this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return true;
    }

    private boolean assignAromaticDoubleForAtom(Atom atom) {
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return false;
        }
        boolean haveDouble = false;
        int lastBond = -1;
        int i = bonds.length;
        while (--i >= 0) {
            if (this.bsAromaticDouble.get(bonds[i].index)) {
                haveDouble = true;
            }
            if (!bonds[i].isAromatic()) continue;
            lastBond = i;
        }
        i = bonds.length;
        while (--i >= 0) {
            Bond bond = bonds[i];
            int bondIndex = bond.index;
            if (!bond.isAromatic() || this.bsAromaticDouble.get(bondIndex) || this.bsAromaticSingle.get(bondIndex)) continue;
            if (!haveDouble && this.assignAromaticDouble(bond)) {
                haveDouble = true;
                continue;
            }
            if (!haveDouble && i >= lastBond || this.assignAromaticSingle(bond)) continue;
            return false;
        }
        return haveDouble;
    }

    protected boolean allowAromaticBond(Bond b) {
        if (this.assignAromaticMustBeSingle(b.atom1) || this.assignAromaticMustBeSingle(b.atom2)) {
            return false;
        }
        switch (b.getCovalentOrder()) {
            case 1: 
            case 2: {
                return b.atom1.getCovalentBondCount() <= 3 && b.atom2.getCovalentBondCount() <= 3;
            }
        }
        return false;
    }

    private boolean assignAromaticMustBeSingle(Atom atom) {
        int n = atom.getElementNumber();
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                return true;
            }
        }
        int valence = atom.getValenceAromatic(false);
        switch (n) {
            case 6: {
                return valence == 4;
            }
            case 7: {
                return atom.group.getNitrogenAtom() == atom || valence == 3 && atom.getFormalCharge() < 1;
            }
            case 8: {
                return atom.group.getCarbonylOxygenAtom() != atom && valence == 2 && atom.getFormalCharge() < 1;
            }
            case 16: {
                return atom.group.groupID == 5 || valence == 2 && atom.getFormalCharge() < 1;
            }
        }
        return false;
    }

    private void assignAromaticNandO(BS bsSelected) {
        int i0;
        boolean isAll = bsSelected == null;
        int i = i0 = isAll ? this.bondCount - 1 : bsSelected.nextSetBit(0);
        while (i >= 0) {
            Bond bond = this.bo[i];
            if (bond != null && bond.is(513)) {
                int valence;
                Atom atom1;
                int n1;
                Atom atom2 = bond.atom2;
                int n2 = atom2.getElementNumber();
                if (n2 == 7 || n2 == 8) {
                    n1 = n2;
                    atom1 = atom2;
                    atom2 = bond.atom1;
                    n2 = atom2.getElementNumber();
                } else {
                    atom1 = bond.atom1;
                    n1 = atom1.getElementNumber();
                }
                if ((n1 == 7 || n1 == 8) && (valence = atom1.getValence()) >= 0) {
                    int bondorder = atom1.getCovalentBondCount();
                    int charge = atom1.getFormalCharge();
                    switch (n1) {
                        case 7: {
                            if (valence != 3 || bondorder != 3 || charge >= 1 || n2 != 6 || atom2.getValence() != 3) break;
                            bond.setOrder(514);
                            break;
                        }
                        case 8: {
                            if (valence != 1 || charge != 0 || n2 != 14 && n2 != 16) break;
                            bond.setOrder(514);
                        }
                    }
                }
            }
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
    }

    protected BS getAtomBitsMDb(int tokType, Object specInfo) {
        BS bs = new BS();
        switch (tokType) {
            default: {
                return this.getAtomBitsMDa(tokType, specInfo, bs);
            }
            case 1677721602: {
                BS bsBonds = (BS)specInfo;
                int i = bsBonds.nextSetBit(0);
                while (i >= 0) {
                    if (i < this.bondCount && this.bo[i] != null) {
                        bs.set(this.bo[i].atom1.i);
                        bs.set(this.bo[i].atom2.i);
                    } else {
                        bsBonds.clear(i);
                    }
                    i = bsBonds.nextSetBit(i + 1);
                }
                return bs;
            }
            case 1073742331: 
        }
        int i = this.bondCount;
        while (--i >= 0) {
            if (this.bo[i] == null || !this.bo[i].isAromatic()) continue;
            bs.set(this.bo[i].atom1.i);
            bs.set(this.bo[i].atom2.i);
        }
        return bs;
    }

    public void removeUnnecessaryBonds(Atom atom, boolean deleteAtom) {
        BS bs = new BS();
        BS bsBonds = new BS();
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return;
        }
        for (int i = 0; i < bonds.length; ++i) {
            if (bonds[i].isCovalent()) {
                Atom atom2 = bonds[i].getOtherAtom(atom);
                if (atom2.getElementNumber() != 1) continue;
                bs.set(bonds[i].getOtherAtom((Atom)atom).i);
                continue;
            }
            bsBonds.set(bonds[i].index);
        }
        if (bsBonds.nextSetBit(0) >= 0) {
            ((ModelSet)this).deleteBonds(bsBonds, false);
        }
        if (deleteAtom) {
            bs.set(atom.i);
        }
        if (bs.nextSetBit(0) >= 0) {
            this.vwr.deleteAtoms(bs, false);
        }
    }

    public void displayBonds(BondSet bs, boolean isDisplay) {
        if (!isDisplay) {
            this.haveHiddenBonds = true;
        }
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (i < this.bondCount && this.bo[i] != null && this.bo[i].mad != 0) {
                this.bo[i].setShapeVisibility(isDisplay);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    public BS getAtomsConnected(float min, float max, int intType, BS bs) {
        int i;
        boolean isBonds = bs instanceof BondSet;
        BS bsResult = isBonds ? new BondSet() : new BS();
        int[] nBonded = new int[this.ac];
        boolean ishbond = intType == 30720;
        boolean isall = intType == 65535;
        for (int ibond = 0; ibond < this.bondCount; ++ibond) {
            Bond bond = this.bo[ibond];
            if (bond == null || !isall && !bond.is(intType) && (!ishbond || !bond.isHydrogen())) continue;
            if (isBonds) {
                bsResult.set(ibond);
                continue;
            }
            if (bs.get(bond.atom1.i)) {
                i = bond.atom2.i;
                nBonded[i] = nBonded[i] + 1;
                bsResult.set(i);
            }
            if (!bs.get(bond.atom2.i)) continue;
            i = bond.atom1.i;
            nBonded[i] = nBonded[i] + 1;
            bsResult.set(i);
        }
        if (isBonds) {
            return bsResult;
        }
        boolean nonbonded = min == 0.0f;
        i = this.ac;
        while (--i >= 0) {
            int n = nBonded[i];
            if (this.at[i] == null || (float)n < min || (float)n > max) {
                bsResult.clear(i);
                continue;
            }
            if (!nonbonded || n != 0) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    public void addConnectedHAtoms(Atom atom, BS bsAtoms) {
        if (atom.bonds != null) {
            int i = atom.bonds.length;
            while (--i >= 0) {
                Atom atom2 = atom.bonds[i].getOtherAtom(atom);
                if (atom2.getElementNumber() != 1) continue;
                bsAtoms.set(atom2.i);
            }
        }
    }
}

