/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!H\u0016J)\u0010\"\u001a\u00020\u00152!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b%\u0012\b\b\u0017\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020\u00150$J\b\u0010'\u001a\u00020\u001bH\u0002J\u0006\u0010(\u001a\u00020\u001bJ\b\u0010)\u001a\u00020\u001bH\u0016R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\n0\n0\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/vcs/log/VcsUserRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "_persistentEnumerator", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/io/PersistentEnumeratorBase;", "Lcom/intellij/vcs/log/VcsUser;", "persistentEnumerator", "getPersistentEnumerator", "()Lcom/intellij/util/io/PersistentEnumeratorBase;", "interner", "Lcom/intellij/util/containers/Interner;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "mapFile", "Ljava/io/File;", "initEnumerator", "", "createUser", "name", "", "email", "addUser", "", "user", "addUsers", "users", "", "getUsers", "", "all", "condition", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "t", "rebuild", "flush", "dispose", "Companion", "intellij.platform.vcs.log.impl"})
public final class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<PersistentEnumeratorBase<VcsUser>> _persistentEnumerator;
    @NotNull
    private final Interner<VcsUser> interner;
    @NotNull
    private final File mapFile;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final File USER_CACHE_APP_DIR;
    private static final int STORAGE_VERSION = 2;

    public VcsUserRegistryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this._persistentEnumerator = new AtomicReference();
        Interner interner = Interner.createInterner();
        Intrinsics.checkNotNullExpressionValue((Object)interner, (String)"createInterner(...)");
        this.interner = interner;
        this.mapFile = new File(USER_CACHE_APP_DIR, project.getLocationHash() + ".2");
        this.initEnumerator();
    }

    private final PersistentEnumeratorBase<VcsUser> getPersistentEnumerator() {
        return this._persistentEnumerator.get();
    }

    private final boolean initEnumerator() {
        try {
            PersistentBTreeEnumerator enumerator = (PersistentBTreeEnumerator)IOUtil.openCleanOrResetBroken(() -> VcsUserRegistryImpl.initEnumerator$lambda$0(this), (File)this.mapFile);
            boolean wasSet = this._persistentEnumerator.compareAndSet(null, (PersistentEnumeratorBase<VcsUser>)enumerator);
            if (!wasSet) {
                LOG.error("Could not assign newly opened enumerator");
                PersistentBTreeEnumerator persistentBTreeEnumerator = enumerator;
                if (persistentBTreeEnumerator != null) {
                    persistentBTreeEnumerator.close();
                }
            }
            return wasSet;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public VcsUser createUser(@NotNull String name, @NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        Interner<VcsUser> interner = this.interner;
        synchronized (interner) {
            boolean bl = false;
            Object object = this.interner.intern((Object)new VcsUserImpl(name, email));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"intern(...)");
            VcsUser vcsUser = (VcsUser)object;
            return vcsUser;
        }
    }

    public final void addUser(@NotNull VcsUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
        }
    }

    public final void addUsers(@NotNull Collection<? extends VcsUser> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        for (VcsUser vcsUser : users) {
            this.addUser(vcsUser);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        Object object;
        try {
            Object object2 = this.getPersistentEnumerator();
            if (object2 == null || (object2 = object2.getAllDataObjects(VcsUserRegistryImpl::getUsers$lambda$2)) == null || (object2 = (Set)CollectionsKt.filterNotNullTo((Iterable)((Iterable)object2), (Collection)new LinkedHashSet())) == null) {
                object2 = SetsKt.emptySet();
            }
            object = object2;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
            object = SetsKt.emptySet();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            LOG.error(t);
            object = SetsKt.emptySet();
        }
        return object;
    }

    public final boolean all(@NotNull Function1<? super VcsUser, Boolean> condition) {
        boolean bl;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            bl = persistentEnumeratorBase != null ? persistentEnumeratorBase.iterateData(arg_0 -> VcsUserRegistryImpl.all$lambda$3(condition, arg_0)) : false;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            this.rebuild();
            bl = false;
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable t) {
            LOG.error(t);
            bl = false;
        }
        return bl;
    }

    private final void rebuild() {
        block1: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            boolean bl = persistentEnumeratorBase != null ? persistentEnumeratorBase.isCorrupted() : false;
            if (!bl) break block1;
            PersistentEnumeratorBase persistentEnumeratorBase2 = this._persistentEnumerator.getAndSet(null);
            if (persistentEnumeratorBase2 != null) {
                PersistentEnumeratorBase oldEnumerator = persistentEnumeratorBase2;
                boolean bl2 = false;
                ApplicationManager.getApplication().executeOnPooledThread(() -> VcsUserRegistryImpl.rebuild$lambda$5$lambda$4(oldEnumerator, this));
            }
        }
    }

    public final void flush() {
        block0: {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase == null) break block0;
            persistentEnumeratorBase.force();
        }
    }

    public void dispose() {
        try {
            PersistentEnumeratorBase<VcsUser> persistentEnumeratorBase = this.getPersistentEnumerator();
            if (persistentEnumeratorBase != null) {
                persistentEnumeratorBase.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static final PersistentBTreeEnumerator initEnumerator$lambda$0(VcsUserRegistryImpl this$0) {
        return new PersistentBTreeEnumerator(this$0.mapFile.toPath(), (KeyDescriptor)new VcsUserKeyDescriptor(this$0), AbstractStorage.PAGE_SIZE, null, 2);
    }

    private static final boolean getUsers$lambda$2(int it) {
        return true;
    }

    private static final boolean all$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void rebuild$lambda$5$lambda$4(PersistentEnumeratorBase $oldEnumerator, VcsUserRegistryImpl this$0) {
        try {
            $oldEnumerator.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this$0.initEnumerator();
        }
    }

    static {
        Logger logger = Logger.getInstance(VcsUserRegistryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/log/data/VcsUserRegistryImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "USER_CACHE_APP_DIR", "Ljava/io/File;", "STORAGE_VERSION", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

