/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.backend.services;

import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.project.ProjectId;
import com.intellij.platform.project.ProjectIdKt;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.service.VirtualFileAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/markdown/backend/services/VirtualFileAccessorImpl;", "Lorg/intellij/plugins/markdown/service/VirtualFileAccessor;", "<init>", "()V", "getBaseDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectId", "Lcom/intellij/platform/project/ProjectId;", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "getFileByResourceName", "resourceName", "", "(Ljava/lang/String;Lcom/intellij/ide/vfs/VirtualFileId;Lcom/intellij/platform/project/ProjectId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.markdown.backend"})
public final class VirtualFileAccessorImpl
implements VirtualFileAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    private final VirtualFile getBaseDirectory(ProjectId projectId, VirtualFileId virtualFileId) {
        Project project = ProjectIdKt.findProject((ProjectId)projectId);
        VirtualFile virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)virtualFileId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile baseDirectory = BaseProjectDirectories.Companion.getInstance(project).getBaseDirectoryFor(virtualFile2);
        return baseDirectory;
    }

    @Nullable
    public Object getFileByResourceName(@NotNull String resourceName, @NotNull VirtualFileId virtualFileId, @NotNull ProjectId projectId, @NotNull Continuation<? super VirtualFileId> $completion) {
        Object object;
        VirtualFile projectRoot = this.getBaseDirectory(projectId, virtualFileId);
        if (StringsKt.startsWith$default((String)resourceName, (String)"file:/", (boolean)false, (int)2, null)) {
            object = VfsUtil.findFileByIoFile((File)new File(new URL(resourceName).getPath()), (boolean)true);
        } else {
            VirtualFile virtualFile = projectRoot;
            object = virtualFile != null ? virtualFile.findFileByRelativePath(resourceName) : null;
        }
        if (object == null) {
            return null;
        }
        VirtualFile resource = object;
        return VirtualFileIdKt.rpcId((VirtualFile)resource);
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileAccessorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VirtualFileAccessorImpl.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/markdown/backend/services/VirtualFileAccessorImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.markdown.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

