/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinMissingForOrWhileBodyFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "<init>", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "isValidLoopCondition", "", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "kotlin.base.code-insight.minimal"})
public final class KotlinMissingForOrWhileBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KtForExpression) && !(element instanceof KtWhileExpression)) {
            return;
        }
        KtLoopExpression loopExpression = (KtLoopExpression)element;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        KtExpression body = loopExpression.getBody();
        if (body instanceof KtBlockExpression) {
            return;
        }
        if (!this.isValidLoopCondition(loopExpression)) {
            return;
        }
        if (body != null && FixersUtilKt.startLine((PsiElement)body, doc) == FixersUtilKt.startLine((PsiElement)loopExpression, doc)) {
            return;
        }
        PsiElement psiElement = loopExpression.getRightParenthesis();
        if (psiElement == null) {
            return;
        }
        PsiElement rParen = psiElement;
        doc.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{}");
    }

    private final boolean isValidLoopCondition(KtLoopExpression $this$isValidLoopCondition) {
        return $this$isValidLoopCondition.getLeftParenthesis() != null && $this$isValidLoopCondition.getRightParenthesis() != null;
    }
}

