/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.importer.LocationResolver;
import com.tngtech.archunit.core.importer.UrlSource;
import com.tngtech.archunit.thirdparty.com.google.common.base.Splitter;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.io.File;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ModuleLocationResolver
implements LocationResolver {
    private final LocationResolver.FromClasspathAndUrlClassLoaders standardResolver = new LocationResolver.FromClasspathAndUrlClassLoaders();

    ModuleLocationResolver() {
    }

    @Override
    public UrlSource resolveClassPath() {
        UrlSource classpath = this.standardResolver.resolveClassPath();
        Set<ModuleReference> systemModuleReferences = ModuleFinder.ofSystem().findAll();
        Set<ModuleReference> configuredModuleReferences = ModuleFinder.of(this.modulepath()).findAll();
        Iterable modulepath = Stream.concat(systemModuleReferences.stream(), configuredModuleReferences.stream()).flatMap(moduleReference -> moduleReference.location().stream()).map(this::toUrl).collect(Collectors.toList());
        return UrlSource.From.iterable(Iterables.concat(classpath, modulepath));
    }

    private Path[] modulepath() {
        String modulepathProperty = Strings.nullToEmpty(System.getProperty("jdk.module.path"));
        List<String> modulepath = Splitter.on(File.pathSeparatorChar).omitEmptyStrings().splitToList(modulepathProperty);
        return (Path[])modulepath.stream().map(x$0 -> Paths.get(x$0, new String[0])).toArray(Path[]::new);
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

