/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.registry;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.utils.CommonUtils;

public class DataTransferEventProcessorDescriptor
extends AbstractDescriptor {
    private final String id;
    private final AbstractDescriptor.ObjectType type;
    private final String label;
    private final String description;
    private final int order;
    private final Set<String> applicableNodeIds;

    protected DataTransferEventProcessorDescriptor(@NotNull IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        this.applicableNodeIds = new HashSet<String>(Arrays.asList(config.getAttribute("nodes").split(",")));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public AbstractDescriptor.ObjectType getType() {
        return this.type;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isApplicable(@NotNull String nodeId) {
        return this.applicableNodeIds.contains(nodeId);
    }

    @NotNull
    public <T extends IDataTransferConsumer<?, ?>> IDataTransferEventProcessor<T> create() throws DBException {
        this.type.checkObjectClass(IDataTransferEventProcessor.class);
        try {
            return (IDataTransferEventProcessor)this.type.getImplClass(IDataTransferEventProcessor.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new DBException("Can't create event processor", e);
        }
    }
}

