/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.sql.ast;

import java.util.List;
import org.hibernate.dialect.MySQLDeleteOrUpsertOperation;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.ast.spi.SqlAstTranslatorWithUpsert;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.UpsertOperation;

public class SqlAstTranslatorWithOnDuplicateKeyUpdate<T extends JdbcOperation>
extends SqlAstTranslatorWithUpsert<T> {
    public SqlAstTranslatorWithOnDuplicateKeyUpdate(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public MutationOperation createMergeOperation(OptionalTableUpdate optionalTableUpdate) {
        assert (optionalTableUpdate.getNumberOfOptimisticLockBindings() == 0);
        this.renderUpsertStatement(optionalTableUpdate);
        UpsertOperation upsertOperation = new UpsertOperation(optionalTableUpdate.getMutatingTable().getTableMapping(), optionalTableUpdate.getMutationTarget(), this.getSql(), this.getParameterBinders());
        return new MySQLDeleteOrUpsertOperation(optionalTableUpdate.getMutationTarget(), (EntityTableMapping)optionalTableUpdate.getMutatingTable().getTableMapping(), upsertOperation, optionalTableUpdate);
    }

    @Override
    protected void renderUpsertStatement(OptionalTableUpdate optionalTableUpdate) {
        this.renderInsertInto(optionalTableUpdate);
        this.appendSql(" ");
        this.renderOnDuplicateKeyUpdate(optionalTableUpdate);
    }

    protected void renderInsertInto(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("insert into ");
        this.appendSql(optionalTableUpdate.getMutatingTable().getTableName());
        this.appendSql(" (");
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        for (ColumnValueBinding keyBinding : keyBindings) {
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
            this.appendSql(',');
        }
        optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
            this.appendSql(columnValueBinding.getColumnReference().getColumnExpression());
            if (columnPosition != optionalTableUpdate.getValueBindings().size() - 1) {
                this.appendSql(',');
            }
        });
        this.appendSql(") values (");
        for (ColumnValueBinding keyBinding : keyBindings) {
            keyBinding.getValueExpression().accept(this);
            this.appendSql(',');
        }
        optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
            if (columnPosition > 0) {
                this.appendSql(',');
            }
            columnValueBinding.getValueExpression().accept(this);
        });
        this.appendSql(") ");
        this.renderNewRowAlias();
    }

    protected void renderNewRowAlias() {
    }

    protected void renderOnDuplicateKeyUpdate(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("on duplicate key update ");
        optionalTableUpdate.forEachValueBinding((columnPosition, columnValueBinding) -> {
            String columnName = columnValueBinding.getColumnReference().getColumnExpression();
            if (columnPosition > 0) {
                this.appendSql(',');
            }
            this.appendSql(columnName);
            this.append(" = ");
            this.renderUpdatevalue((ColumnValueBinding)columnValueBinding);
        });
    }

    protected void renderUpdatevalue(ColumnValueBinding columnValueBinding) {
    }
}

