/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.grid.GridColorSchemeUtil;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.TableCellImageCache;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactories;
import com.intellij.database.run.ui.treetable.GridTreeTableModel;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridTreeTable
extends JBTreeTable
implements Disposable,
EditorColorsListener,
ResultViewWithRows {
    private final DataGrid myResultPanel;
    private final TreeTableResultView myView;
    private final TableCellImageCache myCellImageCache;
    private final FieldNameColumnRenderer myFieldNameRenderer;
    private final ValueColumnRenderer myValueColumnRenderer;

    public GridTreeTable(@NotNull TreeTableModel model2, @NotNull DataGrid resultPanel, @NotNull TreeTableResultView view) {
        if (model2 == null) {
            GridTreeTable.$$$reportNull$$$0(0);
        }
        if (resultPanel == null) {
            GridTreeTable.$$$reportNull$$$0(1);
        }
        if (view == null) {
            GridTreeTable.$$$reportNull$$$0(2);
        }
        super(model2);
        this.myResultPanel = resultPanel;
        this.myView = view;
        this.myCellImageCache = new TableCellImageCache(this, view);
        this.setColumnProportion(0.7f);
        this.myFieldNameRenderer = new FieldNameColumnRenderer();
        Disposer.register((Disposable)this, (Disposable)this.myFieldNameRenderer);
        UIUtil.putClientProperty((JComponent)this.getTable(), (Key)RenderingUtil.CUSTOM_SELECTION_BACKGROUND, () -> this.getTable().getSelectionBackground());
        this.setDefaultRenderer(TreeTableModel.class, this.myFieldNameRenderer);
        this.myValueColumnRenderer = new ValueColumnRenderer(resultPanel, this, view, this.getDefaultRenderer(Object.class));
        this.setDefaultRenderer(Object.class, this.myValueColumnRenderer);
        this.getTree().setLargeModel(true);
        this.getTable().getEmptyText().setText("");
        this.getTree().getEmptyText().setText("");
        this.getTable().setBorder((Border)JBUI.Borders.emptyBottom((int)150));
        this.getTree().setBorder((Border)JBUI.Borders.emptyBottom((int)150));
        this.hideColumnHeader();
        this.getTable().setShowVerticalLines(true);
        this.colorSchemeUpdated();
        MessageBusConnection connection = resultPanel.getProject().getMessageBus().connect((Disposable)this);
    }

    private int getTextLineHeight() {
        return (int)Math.ceil((float)this.getFontMetrics(this.getFont()).getHeight() * this.getColorsScheme().getLineSpacing());
    }

    public Font getFont() {
        return this.getColorsScheme().getFont(EditorFontType.PLAIN);
    }

    private void hideColumnHeader() {
        this.getTable().setTableHeader(null);
        JScrollPane scrollPane = this.getScrollPane();
        if (scrollPane != null) {
            scrollPane.setColumnHeaderView(null);
        }
    }

    protected void paintComponent(Graphics g) {
        this.adjustCacheSize();
        super.paintComponent(g);
    }

    private void adjustCacheSize() {
        if (!this.myCellImageCache.isCacheEnabled()) {
            return;
        }
        int rowCount = this.getTable().getRowCount();
        Rectangle visibleRect = this.getVisibleRect();
        if (rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int rowHeight = this.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        rowsMax = Math.min(100, rowsMax);
        int columnsMax = 2;
        int factor = Math.max(1, Registry.intValue((String)"database.grid.cache.factor"));
        int treeTableFactor = 3;
        this.myCellImageCache.adjustCacheSize(rowsMax * columnsMax * factor * treeTableFactor);
    }

    private void colorSchemeUpdated() {
        this.getTable().setGridColor(GridColorSchemeUtil.doGetGridColor(this.getColorsScheme()));
        this.updateInnerComponentsBackground(GridColorSchemeUtil.doGetBackground(this.getColorsScheme()));
        this.getTable().setSelectionBackground(GridColorSchemeUtil.doGetSelectionBackground(this.getColorsScheme()));
        this.getTable().setSelectionForeground(GridColorSchemeUtil.doGetSelectionForeground(this.getColorsScheme()));
        this.getTree().setRowHeight(this.getTextLineHeight() + this.getTable().getRowMargin());
    }

    private void updateInnerComponentsBackground(Color bg) {
        this.getTree().setBackground(bg);
        this.getTable().setBackground(bg);
    }

    @NotNull
    private GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myResultPanel.getColorsScheme();
        if (gridColorsScheme == null) {
            GridTreeTable.$$$reportNull$$$0(3);
        }
        return gridColorsScheme;
    }

    public Color getBackground() {
        return GridColorSchemeUtil.doGetBackground(this.getColorsScheme());
    }

    public void setBackground(@NotNull Color bg) {
        if (bg == null) {
            GridTreeTable.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void resetRowHeights() {
        int defaultRowHeight = this.getRowHeight();
        JBTable table2 = this.getTable();
        for (int i = 0; i < table2.getRowCount(); ++i) {
            if (table2.getRowHeight(i) == defaultRowHeight) continue;
            table2.setRowHeight(i, defaultRowHeight);
        }
    }

    public GridTreeTableModel getModel() {
        return (GridTreeTableModel)super.getModel();
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        if (path == null) {
            GridTreeTable.$$$reportNull$$$0(5);
        }
        ViewIndex rowIdx = ViewIndex.forRow((CoreGrid)this.myResultPanel, (int)row);
        ViewIndex colIdx = ViewIndex.forColumn((CoreGrid)this.myResultPanel, (int)0);
        SelectionModel selectionModel = SelectionModelUtil.get(this.myResultPanel, this.myView);
        boolean selected = selectionModel.isSelected(rowIdx, colIdx);
        return this.myView.getCellBackground((ViewIndex<GridRow>)rowIdx, (ViewIndex<GridColumn>)colIdx, selected);
    }

    public void dispose() {
        this.getTable().removeEditor();
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.myFieldNameRenderer.myComponent.getEditor().reinitSettings();
        this.colorSchemeUpdated();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridTreeTable gridTreeTable = this;
        if (gridTreeTable == null) {
            GridTreeTable.$$$reportNull$$$0(6);
        }
        return gridTreeTable;
    }

    @Nullable
    private JScrollPane getScrollPane() {
        if (this.getComponentCount() < 1) {
            return null;
        }
        Splitter split = (Splitter)ObjectUtils.tryCast((Object)this.getComponent(0), Splitter.class);
        return split == null ? null : (JScrollPane)ObjectUtils.tryCast((Object)split.getFirstComponent(), JScrollPane.class);
    }

    @Override
    @Nullable
    public JScrollBar getVerticalScrollBar() {
        JScrollPane scrollPane = this.getScrollPane();
        return scrollPane == null ? null : scrollPane.getVerticalScrollBar();
    }

    @Override
    @Nullable
    public JScrollBar getHorizontalScrollBar() {
        JScrollPane scrollPane = this.getScrollPane();
        return scrollPane == null ? null : scrollPane.getHorizontalScrollBar();
    }

    @Override
    public int getRowHeight() {
        return this.getTable().getRowHeight();
    }

    public void clearCache() {
        this.myCellImageCache.reset();
        this.revalidate();
        this.repaint();
    }

    public void reinitSettings() {
        this.myCellImageCache.reset();
        GridCellRendererFactories.get(this.myResultPanel).reinitSettings();
        this.myValueColumnRenderer.reinitSettings();
        this.myFieldNameRenderer.reinitSettings();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/treetable/GridTreeTable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bg";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/treetable/GridTreeTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    private class FieldNameColumnRenderer
    implements TableCellRenderer,
    Disposable {
        final EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;

        private FieldNameColumnRenderer() {
            this.myComponent = DefaultTextRendererFactory.TextRenderer.createComponent(GridTreeTable.this.myResultPanel.getProject(), null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            EditorEx editor = this.myComponent.getEditor();
            if (editor.isDisposed()) {
                return this.myComponent;
            }
            DefaultTextRendererFactory.TextRenderer.configureEditor(editor, GridTreeTable.this.myResultPanel);
            TextAttributes attributes = DefaultTextRendererFactory.TextRenderer.getAttributes(value, (TextAttributesScheme)editor.getColorsScheme(), isSelected, false);
            this.myComponent.setText(((Node)value).getName(), attributes, isSelected);
            return ResultViewWithCells.prepareComponent((Component)this.myComponent, GridTreeTable.this.myResultPanel, GridTreeTable.this.myView, (ViewIndex<GridRow>)ViewIndex.forRow((CoreGrid)GridTreeTable.this.myResultPanel, (int)row), (ViewIndex<GridColumn>)ViewIndex.forColumn((CoreGrid)GridTreeTable.this.myResultPanel, (int)column), true);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myComponent);
        }

        public void reinitSettings() {
            this.myComponent.getEditor().reinitSettings();
        }
    }

    private static final class ValueColumnRenderer
    implements TableCellRenderer {
        final Renderers myRenderers;
        final DataGrid myDataGrid;
        final GridTreeTable myTreeTable;
        final TreeTableResultView myView;
        final TableCellRenderer myDefaultRenderer;

        private ValueColumnRenderer(DataGrid dataGrid, GridTreeTable treeTable, TreeTableResultView view, TableCellRenderer defaultRenderer) {
            this.myDataGrid = dataGrid;
            this.myTreeTable = treeTable;
            this.myView = view;
            this.myDefaultRenderer = defaultRenderer;
            this.myRenderers = new Renderers(dataGrid, treeTable);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer renderer2 = this.myRenderers.getRenderer(row, 1);
            renderer2 = renderer2 != null ? renderer2 : this.myDefaultRenderer;
            renderer2 = this.myTreeTable.myCellImageCache.wrapCellRenderer(renderer2);
            Component component = renderer2.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            ViewIndex rowIdx = ViewIndex.forRow((CoreGrid)this.myDataGrid, (int)row);
            ViewIndex columnIdx = ViewIndex.forColumn((CoreGrid)this.myDataGrid, (int)column);
            return ResultViewWithCells.prepareComponent(component, this.myDataGrid, this.myView, (ViewIndex<GridRow>)rowIdx, (ViewIndex<GridColumn>)columnIdx, true);
        }

        public void reinitSettings() {
            this.myRenderers.reinitSettings();
        }
    }

    private static class GridCellRendererWrapper
    implements TableCellRenderer {
        final GridCellRenderer delegate;

        GridCellRendererWrapper(GridCellRenderer renderer2) {
            this.delegate = renderer2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataGrid grid = this.delegate.myGrid;
            ViewIndex rowIdx = ViewIndex.forRow((CoreGrid)grid, (int)row);
            ViewIndex columnIdx = ViewIndex.forColumn((CoreGrid)grid, (int)column);
            return this.delegate.getComponent((ViewIndex<GridRow>)rowIdx, (ViewIndex<GridColumn>)columnIdx, value);
        }
    }

    private static class Renderers {
        final GridCellRenderer myJsonRenderer;
        final GridCellRenderer myEmptyRenderer;
        private final DataGrid myGrid;
        final GridTreeTable myTreeTable;
        final Map<GridCellRenderer, TableCellRenderer> myTableCellRenderers = new Reference2ObjectOpenHashMap();

        Renderers(DataGrid grid, GridTreeTable treeTable) {
            this.myGrid = grid;
            this.myTreeTable = treeTable;
            this.myEmptyRenderer = new DefaultTextRendererFactory.TextRenderer(this, grid){

                @Override
                @NotNull
                protected String getValueText(@NotNull ModelIndex<GridColumn> columnIdx, @NotNull Object value) {
                    if (columnIdx == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "columnIdx";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "value";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/run/ui/treetable/GridTreeTable$Renderers$1";
                    objectArray[2] = "getValueText";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myJsonRenderer = new DefaultTextRendererFactory.TextRenderer(grid, "JSON5", false);
            Disposer.register((Disposable)grid, (Disposable)this.myEmptyRenderer);
            Disposer.register((Disposable)grid, (Disposable)this.myJsonRenderer);
        }

        @Nullable
        public TableCellRenderer getRenderer(int viewRow, int viewColumn) {
            Pair rowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun((Object)viewRow, (Object)viewColumn);
            int modelColumnIdx = (Integer)rowAndColumn.second;
            GridCellRenderer gridCellRenderer = this.myTreeTable.getTree().isExpanded(viewRow) ? this.myEmptyRenderer : (modelColumnIdx == -1 ? this.myJsonRenderer : GridCellRenderer.getRenderer(this.myGrid, (ModelIndex<GridRow>)ModelIndex.forRow((CoreGrid)this.myGrid, (int)((Integer)rowAndColumn.first)), (ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)this.myGrid, (int)modelColumnIdx)));
            TableCellRenderer renderer2 = this.myTableCellRenderers.get(gridCellRenderer);
            if (renderer2 == null) {
                renderer2 = new GridCellRendererWrapper(gridCellRenderer);
                this.myTableCellRenderers.put(gridCellRenderer, renderer2);
            }
            return renderer2;
        }

        public void reinitSettings() {
            this.myJsonRenderer.reinitSettings();
            this.myEmptyRenderer.reinitSettings();
        }
    }
}

