/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.IntegerAccessor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaPackageEntryTableAccessor;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleMainPanel;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;

public final class GroovyLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        if (modelSettings == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return new CodeStyleAbstractConfigurable(this, baseSettings, modelSettings, GroovyBundle.message("language.groovy", new Object[0])){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new GroovyCodeStyleMainPanel(this, this.getCurrentSettings(), settings){};
            }

            public String getHelpTopic() {
                return "reference.settingsdialog.codestyle.groovy";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider$1", "createPanel"));
            }
        };
    }

    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        return new GroovyCodeStyleSettings(settings);
    }

    @NotNull
    public Language getLanguage() {
        GroovyLanguage groovyLanguage = GroovyLanguage.INSTANCE;
        if (groovyLanguage == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return groovyLanguage;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_CONTROL_STATEMENT_IN_ONE_LINE", "KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", "KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "KEEP_SIMPLE_CLASSES_IN_ONE_LINE", "KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", "WRAP_LONG_LINES", "CLASS_BRACE_STYLE", "METHOD_BRACE_STYLE", "LAMBDA_BRACE_STYLE", "BRACE_STYLE", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP", "THROWS_LIST_WRAP", "ALIGN_MULTILINE_THROWS_LIST", "ALIGN_THROWS_KEYWORD", "THROWS_KEYWORD_WRAP", "METHOD_PARAMETERS_WRAP", "ALIGN_MULTILINE_PARAMETERS", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_WRAP", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "PREFER_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_METHOD_BRACKETS", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "ALIGN_GROUP_FIELD_DECLARATIONS", "IF_BRACE_FORCE", "ELSE_ON_NEW_LINE", "SPECIAL_ELSE_IF_TREATMENT", "FOR_STATEMENT_WRAP", "ALIGN_MULTILINE_FOR", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "FOR_BRACE_FORCE", "WHILE_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "RESOURCE_LIST_WRAP", "ALIGN_MULTILINE_RESOURCES", "RESOURCE_LIST_LPAREN_ON_NEXT_LINE", "RESOURCE_LIST_RPAREN_ON_NEXT_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "BINARY_OPERATION_WRAP", "ALIGN_MULTILINE_BINARY_OPERATION", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ASSIGNMENT_WRAP", "ALIGN_MULTILINE_ASSIGNMENT", "TERNARY_OPERATION_WRAP", "ALIGN_MULTILINE_TERNARY_OPERATION", "ARRAY_INITIALIZER_WRAP", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "MODIFIER_LIST_WRAP", "ASSERT_STATEMENT_WRAP", "CLASS_ANNOTATION_WRAP", "METHOD_ANNOTATION_WRAP", "FIELD_ANNOTATION_WRAP", "PARAMETER_ANNOTATION_WRAP", "VARIABLE_ANNOTATION_WRAP", "ENUM_CONSTANTS_WRAP"});
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "USE_FLYING_GEESE_BRACES", GroovyBundle.message("code.style.option.use.flying.geese.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "WRAP_CHAIN_CALLS_AFTER_DOT", GroovyBundle.message("code.style.option.wrap.after.dot", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_CALL_CHAIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "ALIGN_MULTILINE_LIST_OR_MAP", GroovyBundle.message("code.style.option.align.when.multiple", new Object[0]), GroovyBundle.message("code.style.group.list.map.literals", new Object[0]), new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "ALIGN_NAMED_ARGS_IN_MAP", GroovyBundle.message("code.style.option.align.multiline.named.arguments", new Object[0]), GroovyBundle.message("code.style.group.list.map.literals", new Object[0]), new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "IMPORT_ANNOTATION_WRAP", GroovyBundle.message("code.style.option.import.annotations", new Object[0]), null, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "VARIABLE_ANNOTATION_WRAP", new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.renameStandardOption("KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", GroovyBundle.message("code.style.option.simple.lambdas.closures.in.one.line", new Object[0]));
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_GENERAL_CLAUSE_WRAP_POLICY", GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON});
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_ON_WRAP_POLICY", GroovyBundle.message("ginq.code.style.option.wrap.on.clauses", new Object[0]), GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON});
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_INDENT_ON_CLAUSE", GroovyBundle.message("ginq.code.style.option.indent.on.clauses", new Object[0]), GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_HAVING_WRAP_POLICY", GroovyBundle.message("ginq.code.style.option.wrap.having.clauses", new Object[0]), GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS_FOR_SINGLETON, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON});
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_INDENT_HAVING_CLAUSE", GroovyBundle.message("ginq.code.style.option.indent.having.clauses", new Object[0]), GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "GINQ_SPACE_AFTER_KEYWORD", GroovyBundle.message("ginq.code.style.option.space.after.keyword", new Object[0]), GroovyBundle.message("ginq.code.style.group.ginq.clauses", new Object[0]), new Object[0]);
            return;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INSERT_FIRST_SPACE_IN_LINE", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AROUND_LAMBDA_ARROW", "SPACE_AFTER_COMMA", "SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", "SPACE_BEFORE_COMMA", "SPACE_AFTER_SEMICOLON", "SPACE_BEFORE_SEMICOLON", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_TRY_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_WITHIN_SYNCHRONIZED_PARENTHESES", "SPACE_WITHIN_CAST_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_BRACES", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES", "SPACE_AFTER_TYPE_CAST", "SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_TRY_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_BEFORE_SYNCHRONIZED_PARENTHESES", "SPACE_BEFORE_CLASS_LBRACE", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_SYNCHRONIZED_LBRACE", "SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD", "SPACE_BEFORE_FINALLY_KEYWORD", "SPACE_BEFORE_QUEST", "SPACE_AFTER_QUEST", "SPACE_BEFORE_COLON", "SPACE_AFTER_COLON", "SPACE_BEFORE_ANOTATION_PARAMETER_LIST", "SPACE_WITHIN_ANNOTATION_PARENTHESES"});
            consumer.renameStandardOption("SPACE_AROUND_RELATIONAL_OPERATORS", GroovyBundle.message("code.style.option.relational.operators", new Object[0]));
            consumer.renameStandardOption("SPACE_AROUND_UNARY_OPERATOR", GroovyBundle.message("code.style.option.unary.operators", new Object[0]));
            consumer.renameStandardOption("SPACE_AROUND_LOGICAL_OPERATORS", GroovyBundle.message("code.style.option.logical.operators", new Object[0]));
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_IN_NAMED_ARGUMENT_BEFORE_COLON", GroovyBundle.message("code.style.option.in.named.argument.before.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_IN_NAMED_ARGUMENT", GroovyBundle.message("code.style.option.in.named.argument.after.colon", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_LIST_OR_MAP", GroovyBundle.message("code.style.option.list.maps.literals", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_BEFORE_CLOSURE_LBRACE", GroovyBundle.message("code.style.option.closure.left.brace.in.method.calls", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_LEFT_BRACE, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_GSTRING_INJECTION_BRACES", GroovyBundle.message("code.style.option.gstring.injection.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_WITHIN_TUPLE_EXPRESSION", GroovyBundle.message("code.style.option.tuple.assignment.expression", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_AROUND_REGEX_OPERATORS", GroovyBundle.message("code.style.option.regexp.expression", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_BEFORE_ASSERT_SEPARATOR", GroovyBundle.message("code.style.option.before.assert.separator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_AFTER_ASSERT_SEPARATOR", GroovyBundle.message("code.style.option.after.assert.separator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(GroovyCodeStyleSettings.class, "SPACE_BEFORE_RECORD_PARENTHESES", GroovyBundle.message("code.style.option.before.record.parameter.list", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
            return;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_PACKAGE", "BLANK_LINES_AFTER_PACKAGE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
            return;
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE", "LINE_COMMENT_ADD_SPACE_ON_REFORMAT", "LINE_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_AT_FIRST_COLUMN", "BLOCK_COMMENT_ADD_SPACE"});
            return;
        }
        consumer.showAllStandardOptions();
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (indentOptions == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        commonSettings.SPACE_WITHIN_BRACES = true;
        commonSettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = true;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS || settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS || settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS || settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return GroovyLanguageCodeStyleSettingsProvider.loadSample(settingsType);
        }
        return null;
    }

    private static String loadSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String string;
        if (settingsType == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        String name = "/samples/" + settingsType.name() + ".txt";
        InputStreamReader reader = new InputStreamReader(GroovyLanguageCodeStyleSettingsProvider.class.getResourceAsStream(name), StandardCharsets.UTF_8);
        try {
            string = StreamUtil.readText((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return "";
            }
        }
        ((Reader)reader).close();
        return string;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor(this){
            private JLabel myLabelIndentLabel;
            private IntegerField myLabelIndent;
            private JBLabel myStyleLabel;
            private JComboBox<LabelIndentStyle> myLabelIndentStyle;

            protected void addComponents() {
                super.addComponents();
                this.myLabelIndentLabel = new JLabel(ApplicationBundle.message((String)"editbox.indent.label.indent", (Object[])new Object[0]));
                this.myLabelIndent = new IntegerField(GroovyBundle.message("settings.code.style.label.indent.size", new Object[0]), 0, Integer.MAX_VALUE);
                this.add(this.myLabelIndentLabel, (JComponent)this.myLabelIndent);
                this.myStyleLabel = new JBLabel(GroovyBundle.message("settings.code.style.label.indent.style", new Object[0]));
                this.myLabelIndentStyle = new ComboBox((ComboBoxModel)new EnumComboBoxModel(LabelIndentStyle.class));
                this.add((JComponent)this.myStyleLabel, this.myLabelIndentStyle);
            }

            public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                return super.isModified(settings, options) || this.myLabelIndent.getValue() != options.LABEL_INDENT_SIZE || this.isLabelStyleModified(options.LABEL_INDENT_ABSOLUTE, ((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS);
            }

            private boolean isLabelStyleModified(boolean absolute, boolean relative) {
                Object selectedStyle = this.myLabelIndentStyle.getSelectedItem();
                if (absolute) {
                    return selectedStyle != LabelIndentStyle.ABSOLUTE;
                }
                if (relative) {
                    return selectedStyle != LabelIndentStyle.RELATIVE;
                }
                return selectedStyle != LabelIndentStyle.RELATIVE_REVERSED;
            }

            public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
                super.apply(settings, options);
                options.LABEL_INDENT_SIZE = this.myLabelIndent.getValue();
                LabelIndentStyle labelIndentStyle = (LabelIndentStyle)((Object)this.myLabelIndentStyle.getSelectedItem());
                options.LABEL_INDENT_ABSOLUTE = labelIndentStyle == LabelIndentStyle.ABSOLUTE;
                ((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS = labelIndentStyle == LabelIndentStyle.RELATIVE;
            }

            public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
                if (settings == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.reset(settings, options);
                this.myLabelIndent.setValue(Integer.valueOf(options.LABEL_INDENT_SIZE));
                if (options.LABEL_INDENT_ABSOLUTE) {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.ABSOLUTE);
                } else if (((GroovyCodeStyleSettings)settings.getCustomSettings(GroovyCodeStyleSettings.class)).INDENT_LABEL_BLOCKS) {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.RELATIVE);
                } else {
                    this.myLabelIndentStyle.setSelectedItem((Object)LabelIndentStyle.RELATIVE_REVERSED);
                }
            }

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.myLabelIndent.setEnabled(enabled);
                this.myLabelIndentLabel.setEnabled(enabled);
                this.myStyleLabel.setEnabled(enabled);
                this.myLabelIndentStyle.setEnabled(enabled);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider$2";
                objectArray[2] = "reset";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field2) {
        if (codeStyleObject == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        if (field2 == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        if (PackageEntryTable.class.isAssignableFrom(field2.getType())) {
            return new JavaPackageEntryTableAccessor(codeStyleObject, field2);
        }
        if (codeStyleObject instanceof GroovyCodeStyleSettings && field2.getName().endsWith("_ORDER_WEIGHT")) {
            return new IntegerAccessor(this, codeStyleObject, field2){

                public boolean isIgnorable() {
                    return true;
                }
            };
        }
        return super.getAccessor(codeStyleObject, field2);
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(final @NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            GroovyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        if (codeStyleObject instanceof GroovyCodeStyleSettings) {
            try {
                Field onDemandPackagesField = codeStyleObject.getClass().getField("PACKAGES_TO_USE_IMPORT_ON_DEMAND");
                return Collections.singletonList(new JavaPackageEntryTableAccessor(this, codeStyleObject, onDemandPackagesField){

                    public boolean set(@NotNull List<String> extVal) {
                        PackageEntryTable entryTable;
                        if (extVal == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        if ((entryTable = this.fromExternal(extVal)) != null) {
                            ((GroovyCodeStyleSettings)((Object)codeStyleObject)).getPackagesToUseImportOnDemand().copyFrom(entryTable);
                            return true;
                        }
                        return false;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extVal", "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider$4", "set"));
                    }
                });
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return super.getAdditionalAccessors(codeStyleObject);
    }

    public boolean usesCommonKeepLineBreaks() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeStyle/GroovyLanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadSample";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAccessors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static enum LabelIndentStyle {
        ABSOLUTE(GroovyBundle.messagePointer("settings.code.style.absolute", new Object[0])),
        RELATIVE(GroovyBundle.messagePointer("settings.code.style.indent.statements.after.label", new Object[0])),
        RELATIVE_REVERSED(GroovyBundle.messagePointer("settings.code.style.indent.labels", new Object[0]));

        private final Supplier<String> description;

        private LabelIndentStyle(Supplier<String> description) {
            this.description = description;
        }

        public String toString() {
            return this.description.get();
        }
    }
}

