/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.DataPackKt;
import com.intellij.vcs.log.data.EmptyLogStorage;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B?\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/data/DataPack;", "Lcom/intellij/vcs/log/data/DataPackBase;", "refsModel", "Lcom/intellij/vcs/log/data/RefsModel;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "providers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "full", "", "<init>", "(Lcom/intellij/vcs/log/data/RefsModel;Lcom/intellij/vcs/log/graph/PermanentGraph;Ljava/util/Map;Z)V", "getPermanentGraph", "()Lcom/intellij/vcs/log/graph/PermanentGraph;", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "ErrorDataPack", "Companion", "intellij.platform.vcs.log.impl"})
public class DataPack
extends DataPackBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermanentGraph<Integer> permanentGraph;
    @JvmField
    @NotNull
    public static final DataPack EMPTY;

    public DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, boolean full) {
        Intrinsics.checkNotNullParameter((Object)refsModel, (String)"refsModel");
        Intrinsics.checkNotNullParameter(permanentGraph, (String)"permanentGraph");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        super(providers, refsModel, full);
        this.permanentGraph = permanentGraph;
    }

    @NotNull
    public final PermanentGraph<Integer> getPermanentGraph() {
        return this.permanentGraph;
    }

    @NotNull
    public String toString() {
        return "{DataPack. " + this.permanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }

    @JvmStatic
    @NotNull
    public static final DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
        return Companion.build(commits, refs, providers, storage, full);
    }

    static {
        VcsLogStorage vcsLogStorage = EmptyLogStorage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"INSTANCE");
        RefsModel refsModel = RefsModel.Companion.createEmptyInstance(vcsLogStorage);
        PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
        Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
        EMPTY = new DataPack(refsModel, permanentGraph, MapsKt.emptyMap(), false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JX\u0010\u0006\u001a\u00020\u00052\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\nj\u0002`\u000b0\t0\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/data/DataPack$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/vcs/log/data/DataPack;", "build", "commits", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "full", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            RefsModel refsModel = RefsModel.Companion.create(refs, DataPackKt.access$getHeads(commits), storage, providers);
            PermanentGraph permanentGraph = DataPackKt.access$buildPermanentGraph(commits, refsModel, providers, storage);
            return new DataPack(refsModel, (PermanentGraph<Integer>)permanentGraph, providers, full);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/data/DataPack$ErrorDataPack;", "Lcom/intellij/vcs/log/data/DataPack;", "error", "", "<init>", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "intellij.platform.vcs.log.impl"})
    public static final class ErrorDataPack
    extends DataPack {
        @NotNull
        private final Throwable error;

        public ErrorDataPack(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            VcsLogStorage vcsLogStorage = EmptyLogStorage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"INSTANCE");
            RefsModel refsModel = RefsModel.Companion.createEmptyInstance(vcsLogStorage);
            PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
            super(refsModel, permanentGraph, MapsKt.emptyMap(), false);
            this.error = error;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }
    }
}

