/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.impl.UtilsKt;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter;", "", "<init>", "()V", "snapshotClass", "", "classNode", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "snapshotClassExcludingMembers", "alsoExcludeKotlinMetaData", "", "alsoExcludeDebugInfo", "snapshotField", "fieldNode", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "snapshotMethod", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "classVersion", "", "sortClassMembers", "", "emptyClass", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nClassNodeSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNodeSnapshotter.kt\norg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n827#2:87\n855#2,2:88\n827#2:90\n855#2,2:91\n*S KotlinDebug\n*F\n+ 1 ClassNodeSnapshotter.kt\norg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter\n*L\n35#1:87\n35#1:88,2\n40#1:90\n40#1:91,2\n*E\n"})
public final class ClassNodeSnapshotter {
    @NotNull
    public static final ClassNodeSnapshotter INSTANCE = new ClassNodeSnapshotter();

    private ClassNodeSnapshotter() {
    }

    public final long snapshotClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return UtilsKt.hashToLong(byArray);
    }

    public final long snapshotClassExcludingMembers(@NotNull ClassNode classNode, boolean alsoExcludeKotlinMetaData, boolean alsoExcludeDebugInfo) {
        long l;
        AnnotationNode it;
        Iterable $this$filterNotTo$iv$iv;
        boolean $i$f$filterNotTo;
        Collection destination$iv$iv;
        Iterable $this$filterNot$iv;
        boolean $i$f$filterNot;
        ClassNode classNode2;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List originalFields = classNode.fields;
        List originalMethods = classNode.methods;
        List originalVisibleAnnotations = classNode.visibleAnnotations;
        List originalInvisibleAnnotations = classNode.invisibleAnnotations;
        classNode.fields = CollectionsKt.emptyList();
        classNode.methods = CollectionsKt.emptyList();
        if (alsoExcludeKotlinMetaData) {
            List list;
            ClassNode classNode3 = classNode;
            List list2 = originalVisibleAnnotations;
            if (list2 != null) {
                Iterable iterable = list2;
                classNode2 = classNode3;
                $i$f$filterNot = false;
                Iterable iterable2 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (AnnotationNode)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.desc, (Object)"Lkotlin/Metadata;")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                classNode3 = classNode2;
            } else {
                list = classNode3.visibleAnnotations = null;
            }
        }
        if (alsoExcludeDebugInfo) {
            List list;
            ClassNode classNode4 = classNode;
            List list3 = originalInvisibleAnnotations;
            if (list3 != null) {
                $this$filterNot$iv = list3;
                classNode2 = classNode4;
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it = (AnnotationNode)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.desc, (Object)"Lkotlin/jvm/internal/SourceDebugExtension;")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                classNode4 = classNode2;
            } else {
                list = null;
            }
            classNode4.invisibleAnnotations = list;
        }
        long it2 = l = this.snapshotClass(classNode);
        boolean bl = false;
        classNode.fields = originalFields;
        classNode.methods = originalMethods;
        classNode.visibleAnnotations = originalVisibleAnnotations;
        classNode.invisibleAnnotations = originalInvisibleAnnotations;
        return l;
    }

    public static /* synthetic */ long snapshotClassExcludingMembers$default(ClassNodeSnapshotter classNodeSnapshotter, ClassNode classNode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return classNodeSnapshotter.snapshotClassExcludingMembers(classNode, bl, bl2);
    }

    public final long snapshotField(@NotNull FieldNode fieldNode) {
        Intrinsics.checkNotNullParameter((Object)fieldNode, (String)"fieldNode");
        ClassNode classNode = this.emptyClass();
        classNode.fields.add(fieldNode);
        return this.snapshotClass(classNode);
    }

    public final long snapshotMethod(@NotNull MethodNode methodNode, int classVersion) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        ClassNode classNode = this.emptyClass();
        classNode.version = classVersion;
        classNode.methods.add(methodNode);
        return this.snapshotClass(classNode);
    }

    public final void sortClassMembers(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List list = classNode.fields;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fields");
        Function1[] function1Array = new Function1[]{ClassNodeSnapshotter::sortClassMembers$lambda$0, ClassNodeSnapshotter::sortClassMembers$lambda$1};
        CollectionsKt.sortWith((List)list, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        List list2 = classNode.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
        function1Array = new Function1[]{ClassNodeSnapshotter::sortClassMembers$lambda$2, ClassNodeSnapshotter::sortClassMembers$lambda$3};
        CollectionsKt.sortWith((List)list2, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    private final ClassNode emptyClass() {
        ClassNode classNode;
        ClassNode it = classNode = new ClassNode();
        boolean bl = false;
        it.name = "SomeClass";
        return classNode;
    }

    private static final Comparable sortClassMembers$lambda$0(FieldNode it) {
        return (Comparable)((Object)it.name);
    }

    private static final Comparable sortClassMembers$lambda$1(FieldNode it) {
        return (Comparable)((Object)it.desc);
    }

    private static final Comparable sortClassMembers$lambda$2(MethodNode it) {
        return (Comparable)((Object)it.name);
    }

    private static final Comparable sortClassMembers$lambda$3(MethodNode it) {
        return (Comparable)((Object)it.desc);
    }
}

