/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider.pkcs;

import java.io.IOException;
import java.util.Objects;
import net.schmizz.sshj.userauth.keyprovider.pkcs.KeyPairConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RSAPrivateKeyInfoKeyPairConverter
implements KeyPairConverter<PrivateKeyInfo> {
    private static final Logger logger = LoggerFactory.getLogger(RSAPrivateKeyInfoKeyPairConverter.class);

    RSAPrivateKeyInfoKeyPairConverter() {
    }

    @Override
    public PEMKeyPair getKeyPair(PrivateKeyInfo privateKeyInfo) throws IOException {
        Objects.requireNonNull(privateKeyInfo, "Private Key Info required");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        if (!PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithm)) {
            throw new IllegalArgumentException(String.format("RSA Algorithm OID required [%s]", algorithm));
        }
        logger.debug("RSA Algorithm Found [{}]", (Object)algorithm);
        RSAPublicKey rsaPublicKey = this.getRsaPublicKey(privateKeyInfo);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, (ASN1Encodable)rsaPublicKey);
        return new PEMKeyPair(subjectPublicKeyInfo, privateKeyInfo);
    }

    private RSAPublicKey getRsaPublicKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)privateKeyInfo.parsePrivateKey());
        return new RSAPublicKey(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent());
    }
}

