/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.ApplicationInfo;
import oshi.util.ParseUtil;

public final class InstalledAppsData {
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();

    private InstalledAppsData() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        ArrayList<ApplicationInfo> appInfoList = new ArrayList<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY rootKey = entry.getKey();
            List<String> uninstallPaths = entry.getValue();
            for (String registryPath : uninstallPaths) {
                String[] keys;
                for (String key : keys = Advapi32Util.registryGetKeys((WinReg.HKEY)rootKey, (String)registryPath)) {
                    String fullPath = registryPath + "\\" + key;
                    try {
                        String name = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "DisplayName");
                        String version = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "DisplayVersion");
                        String publisher = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "Publisher");
                        String installDate = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallDate");
                        String installLocation = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallLocation");
                        String installSource = InstalledAppsData.getRegistryValueOrUnknown(rootKey, fullPath, "InstallSource");
                        long installDateEpoch = ParseUtil.parseDateToEpoch(installDate, "yyyyMMdd");
                        HashMap<String, String> additionalInfo = new HashMap<String, String>();
                        additionalInfo.put("installLocation", installLocation);
                        additionalInfo.put("installSource", installSource);
                        ApplicationInfo app = new ApplicationInfo(name, version, publisher, installDateEpoch, additionalInfo);
                        appInfoList.add(app);
                    }
                    catch (Win32Exception win32Exception) {
                        // empty catch block
                    }
                }
            }
        }
        return appInfoList;
    }

    private static String getRegistryValueOrUnknown(WinReg.HKEY rootKey, String path, String key) {
        String value = Advapi32Util.registryGetStringValue((WinReg.HKEY)rootKey, (String)path, (String)key);
        return ParseUtil.getStringValueOrUnknown(value);
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

