/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenGAVIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/onlinecompletion/IndexBasedCompletionProvider;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fulltextSearch", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "searchString", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestPrefix", "groupId", "artifactId", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "search", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "nonExactMatches", "", "template", "real", "isLocal", "cacheKey", "getCacheKey", "()Ljava/lang/String;", "intellij.maven"})
public final class IndexBasedCompletionProvider
implements DependencySearchProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String cacheKey;

    public IndexBasedCompletionProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.cacheKey = "IndexBasedCompletionProvider";
    }

    @Nullable
    public Object fulltextSearch(@NotNull String searchString, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.search(new MavenId(searchString));
    }

    @Nullable
    public Object suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull Continuation<? super List<? extends RepositoryArtifactData>> $completion) {
        return this.search(new MavenId(groupId, artifactId, null));
    }

    private final List<RepositoryArtifactData> search(MavenId mavenId) {
        List list;
        MavenLog.LOG.debug("Index: get local maven artifacts started");
        List $this$search_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        MavenGAVIndex index = MavenIndicesManager.Companion.getInstance(this.myProject).getCommonGavIndex();
        Iterator<String> iterator = index.getGroupIds().iterator();
        while (iterator.hasNext()) {
            String groupId;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (groupId == null) continue;
            CharSequence charSequence = mavenId.getGroupId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = mavenId.getGroupId();
                Intrinsics.checkNotNull((Object)string);
                if (!this.nonExactMatches(groupId, string)) continue;
            }
            for (Object e : index.getArtifactIds(groupId)) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String artifactId = (String)e;
                CharSequence charSequence2 = mavenId.getArtifactId();
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    String string = mavenId.getArtifactId();
                    Intrinsics.checkNotNull((Object)string);
                    if (!this.nonExactMatches(artifactId, string)) continue;
                }
                if (artifactId == null) continue;
                Set<String> set = index.getVersions(groupId, artifactId);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getVersions(...)");
                MavenRepositoryArtifactInfo info = new MavenRepositoryArtifactInfo(groupId, artifactId, (Collection)set);
                $this$search_u24lambda_u240.add(info);
                MavenLog.LOG.debug("Index: local maven artifact found " + info.getGroupId() + ":" + info.getArtifactId() + ", completions: " + info.getItems().length);
            }
        }
        List result2 = CollectionsKt.build((List)list);
        MavenLog.LOG.debug("Index: get local maven artifacts finished");
        return result2;
    }

    private final boolean nonExactMatches(String template, String real) {
        char[] cArray = new char[]{'-', '.'};
        List splittedTemplate = StringsKt.split$default((CharSequence)template, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'-', '.'};
        List splittedReal = StringsKt.split$default((CharSequence)real, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        if (splittedTemplate.size() == 1 || splittedReal.size() == 1) {
            return StringUtil.startsWith((CharSequence)template, (CharSequence)real) || StringUtil.startsWith((CharSequence)real, (CharSequence)template);
        }
        int matches = 0;
        int n = Math.min(splittedReal.size(), splittedTemplate.size());
        for (int i2 = 0; i2 < n; ++i2) {
            if (StringUtil.startsWith((CharSequence)((CharSequence)splittedTemplate.get(i2)), (CharSequence)((CharSequence)splittedReal.get(i2))) || StringUtil.startsWith((CharSequence)((CharSequence)splittedReal.get(i2)), (CharSequence)((CharSequence)splittedTemplate.get(i2)))) {
                ++matches;
            }
            if (matches < 2) continue;
            return true;
        }
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    @NotNull
    public String getCacheKey() {
        return this.cacheKey;
    }
}

