/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b'\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0004J\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0004J\u0013\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010 0\u0017H\u0016J\f\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0017H$J\u0012\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00172\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J#\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00172\u0006\u0010'\u001a\u00028\u00012\u0006\u0010)\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0004H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010,\u001a\u00020&X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lorg/jetbrains/debugger/SuspendContextManagerBase;", "T", "Lorg/jetbrains/debugger/SuspendContext;", "CALL_FRAME", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/debugger/SuspendContextManager;", "<init>", "()V", "contextRef", "Ljava/util/concurrent/atomic/AtomicReference;", "getContextRef", "()Ljava/util/concurrent/atomic/AtomicReference;", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "setContext", "", "newContext", "(Lorg/jetbrains/debugger/SuspendContext;)V", "updateContext", "dismissContext", "dismissContextOnDone", "Lorg/jetbrains/concurrency/Promise;", "promise", "contextDismissed", "context", "getContext", "()Lorg/jetbrains/debugger/SuspendContext;", "contextOrFail", "getContextOrFail", "suspend", "", "doSuspend", "setOverlayMessage", "message", "", "restartFrame", "", "callFrame", "(Lorg/jetbrains/debugger/CallFrame;)Lorg/jetbrains/concurrency/Promise;", "currentContext", "(Lorg/jetbrains/debugger/CallFrame;Lorg/jetbrains/debugger/SuspendContext;)Lorg/jetbrains/concurrency/Promise;", "canRestartFrame", "isRestartFrameSupported", "()Z", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public abstract class SuspendContextManagerBase<T extends SuspendContext<? extends CALL_FRAME>, CALL_FRAME extends CallFrame>
implements SuspendContextManager<CALL_FRAME> {
    @NotNull
    private final AtomicReference<T> contextRef = new AtomicReference();
    private final boolean isRestartFrameSupported;

    @NotNull
    public final AtomicReference<T> getContextRef() {
        return this.contextRef;
    }

    @NotNull
    protected abstract DebugEventListener getDebugListener();

    public final void setContext(@NotNull T newContext) {
        Intrinsics.checkNotNullParameter(newContext, (String)"newContext");
        if (!this.contextRef.compareAndSet(null, newContext)) {
            throw new IllegalStateException("Attempt to set context, but current suspend context is already exists");
        }
    }

    public void updateContext(@NotNull SuspendContext<?> newContext) {
        Intrinsics.checkNotNullParameter(newContext, (String)"newContext");
    }

    protected final void dismissContext() {
        block0: {
            SuspendContext suspendContext = (SuspendContext)this.contextRef.get();
            if (suspendContext == null) break block0;
            SuspendContext it = suspendContext;
            boolean bl = false;
            this.contextDismissed(it);
        }
    }

    @NotNull
    protected final Promise<?> dismissContextOnDone(@NotNull Promise<?> promise) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        T context = this.getContextOrFail();
        promise.onSuccess(arg_0 -> SuspendContextManagerBase.dismissContextOnDone$lambda$1(arg_0 -> SuspendContextManagerBase.dismissContextOnDone$lambda$0(this, context, arg_0), arg_0));
        return promise;
    }

    public final void contextDismissed(@NotNull T context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (!this.contextRef.compareAndSet(context, null)) {
            throw new IllegalStateException("Expected " + context + ", but another suspend context exists");
        }
        context.getValueManager().markObsolete();
        this.getDebugListener().resumed(context.getVm());
    }

    @Override
    @Nullable
    public SuspendContext<CALL_FRAME> getContext() {
        return (SuspendContext)this.contextRef.get();
    }

    @NotNull
    public T getContextOrFail() {
        SuspendContext suspendContext = (SuspendContext)this.contextRef.get();
        if (suspendContext == null) {
            throw new IllegalStateException("No current suspend context");
        }
        return (T)suspendContext;
    }

    @Override
    @NotNull
    public Promise<? extends Object> suspend() {
        return this.getContext() == null ? this.doSuspend() : Promises.resolvedPromise();
    }

    @NotNull
    protected abstract Promise<?> doSuspend();

    @Override
    public void setOverlayMessage(@Nullable String message) {
    }

    @Override
    @NotNull
    public Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame) {
        Intrinsics.checkNotNullParameter(callFrame, (String)"callFrame");
        return this.restartFrame(callFrame, this.getContextOrFail());
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame, @NotNull T currentContext) {
        Intrinsics.checkNotNullParameter(callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter(currentContext, (String)"currentContext");
        return Promises.rejectedPromise((String)"Unsupported");
    }

    @Override
    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        return false;
    }

    @Override
    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    private static final Unit dismissContextOnDone$lambda$0(SuspendContextManagerBase this$0, SuspendContext $context, Object it) {
        this$0.contextDismissed($context);
        return Unit.INSTANCE;
    }

    private static final void dismissContextOnDone$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

