/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import java.util.Objects;
import org.assertj.core.util.Preconditions;

public final class Offset<T extends Number> {
    public final T value;
    public final boolean strict;

    public static <T extends Number> Offset<T> offset(T value) {
        Objects.requireNonNull(value);
        Preconditions.checkArgument(value.doubleValue() >= 0.0, "An offset value should be greater than or equal to zero", new Object[0]);
        return new Offset<T>(value, false);
    }

    public static <T extends Number> Offset<T> strictOffset(T value) {
        Objects.requireNonNull(value);
        Preconditions.checkArgument(value.doubleValue() > 0.0, "A strict offset value should be greater than zero", new Object[0]);
        return new Offset<T>(value, true);
    }

    private Offset(T value, boolean strict) {
        this.value = value;
        this.strict = strict;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Offset)) {
            return false;
        }
        Offset other = (Offset)obj;
        return this.strict == other.strict && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.strict);
    }

    public String toString() {
        return "%s%s[value=%s]".formatted(this.strict ? "strict " : "", this.getClass().getSimpleName(), this.value);
    }
}

