/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.internal.ByteArrayUtil;

public interface ByteAccess<T> {
    public byte getByte(T var1, long var2);

    default public int getByteAsUnsignedInt(T data, long idx) {
        return this.getByte(data, idx) & 0xFF;
    }

    default public long getByteAsUnsignedLong(T data, long idx) {
        return (long)this.getByte(data, idx) & 0xFFL;
    }

    default public int getInt(T data, long idx) {
        return this.getByte(data, idx) & 0xFF | (this.getByte(data, idx + 1L) & 0xFF) << 8 | (this.getByte(data, idx + 2L) & 0xFF) << 16 | this.getByte(data, idx + 3L) << 24;
    }

    default public long getIntAsUnsignedLong(T data, long idx) {
        return (long)this.getInt(data, idx) & 0xFFFFFFFFL;
    }

    default public long getLong(T data, long idx) {
        return this.getIntAsUnsignedLong(data, idx) | (long)this.getInt(data, idx + 4L) << 32;
    }

    default public void copyToByteArray(T data, long idx, byte[] array, int off, int len) {
        while (len >= 8) {
            ByteArrayUtil.setLong(array, off, this.getLong(data, idx));
            len -= 8;
            off += 8;
            idx += 8L;
        }
        if (len >= 4) {
            ByteArrayUtil.setInt(array, off, this.getInt(data, idx));
            len -= 4;
            off += 4;
            idx += 4L;
        }
        if (len != 0) {
            array[off] = this.getByte(data, idx);
            if (len != 1) {
                array[off + 1] = this.getByte(data, idx + 1L);
                if (len != 2) {
                    array[off + 2] = this.getByte(data, idx + 2L);
                }
            }
        }
    }
}

