/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.util.function.Function;
import org.gradle.cache.Cache;

public abstract class CacheSupport<K, V>
implements Cache<K, V> {
    @Override
    public V get(K key, Function<? super K, ? extends V> factory) {
        V value = this.doGet(key);
        if (value == null) {
            value = factory.apply(key);
            this.doCache(key, value);
        }
        return value;
    }

    @Override
    public V getIfPresent(K key) {
        return this.doGet(key);
    }

    @Override
    public void put(K key, V value) {
        this.doCache(key, value);
    }

    protected abstract <T extends K> V doGet(T var1);

    protected abstract <T extends K, N extends V> void doCache(T var1, N var2);
}

